/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.internal.column.columnindex;

import hive.org.apache.parquet.io.api.Binary;
import hive.org.apache.parquet.schema.LogicalTypeAnnotation;
import hive.org.apache.parquet.schema.PrimitiveType;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Optional;

public abstract class BinaryTruncator {
    private static final BinaryTruncator NO_OP_TRUNCATOR = new BinaryTruncator(){

        @Override
        public Binary truncateMin(Binary minValue, int length) {
            return minValue;
        }

        @Override
        public Binary truncateMax(Binary maxValue, int length) {
            return maxValue;
        }
    };
    private static final BinaryTruncator DEFAULT_UTF8_TRUNCATOR = new BinaryTruncator(){
        private final CharsetValidator validator = new CharsetValidator(StandardCharsets.UTF_8);

        @Override
        public Binary truncateMin(Binary minValue, int length) {
            if (minValue.length() <= length) {
                return minValue;
            }
            ByteBuffer buffer = minValue.toByteBuffer();
            byte[] array = this.validator.checkValidity(buffer) == Validity.VALID ? this.truncateUtf8(buffer, length) : this.truncate(buffer, length);
            return array == null ? minValue : Binary.fromConstantByteArray(array);
        }

        @Override
        public Binary truncateMax(Binary maxValue, int length) {
            if (maxValue.length() <= length) {
                return maxValue;
            }
            ByteBuffer buffer = maxValue.toByteBuffer();
            byte[] array = this.validator.checkValidity(buffer) == Validity.VALID ? this.incrementUtf8(this.truncateUtf8(buffer, length)) : this.increment(this.truncate(buffer, length));
            return array == null ? maxValue : Binary.fromConstantByteArray(array);
        }

        private byte[] truncate(ByteBuffer buffer, int length) {
            assert (length < buffer.remaining());
            byte[] array = new byte[length];
            buffer.get(array);
            return array;
        }

        private byte[] increment(byte[] array) {
            for (int i = array.length - 1; i >= 0; --i) {
                byte elem = array[i];
                array[i] = elem = (byte)(elem + 1);
                if (elem == 0) continue;
                return array;
            }
            return null;
        }

        private byte[] truncateUtf8(ByteBuffer buffer, int length) {
            assert (length < buffer.remaining());
            ByteBuffer newBuffer = buffer.slice();
            newBuffer.limit(newBuffer.position() + length);
            while (this.validator.checkValidity(newBuffer) != Validity.VALID) {
                newBuffer.limit(newBuffer.limit() - 1);
                if (newBuffer.remaining() != 0) continue;
                return null;
            }
            byte[] array = new byte[newBuffer.remaining()];
            newBuffer.get(array);
            return array;
        }

        private byte[] incrementUtf8(byte[] array) {
            if (array == null) {
                return null;
            }
            ByteBuffer buffer = ByteBuffer.wrap(array);
            for (int i = array.length - 1; i >= 0; --i) {
                byte prev;
                byte inc = prev = array[i];
                block5: while ((inc = (byte)(inc + 1)) != 0) {
                    array[i] = inc;
                    switch (this.validator.checkValidity(buffer)) {
                        case VALID: {
                            return array;
                        }
                        case UNMAPPABLE: {
                            continue block5;
                        }
                    }
                }
                array[i] = prev;
            }
            return null;
        }
    };

    public static BinaryTruncator getTruncator(PrimitiveType type) {
        if (type == null) {
            return NO_OP_TRUNCATOR;
        }
        switch (type.getPrimitiveTypeName()) {
            case INT96: {
                return NO_OP_TRUNCATOR;
            }
            case BINARY: 
            case FIXED_LEN_BYTE_ARRAY: {
                LogicalTypeAnnotation logicalTypeAnnotation = type.getLogicalTypeAnnotation();
                if (logicalTypeAnnotation == null) {
                    return DEFAULT_UTF8_TRUNCATOR;
                }
                return logicalTypeAnnotation.accept(new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<BinaryTruncator>(){

                    @Override
                    public Optional<BinaryTruncator> visit(LogicalTypeAnnotation.StringLogicalTypeAnnotation stringLogicalType) {
                        return Optional.of(DEFAULT_UTF8_TRUNCATOR);
                    }

                    @Override
                    public Optional<BinaryTruncator> visit(LogicalTypeAnnotation.EnumLogicalTypeAnnotation enumLogicalType) {
                        return Optional.of(DEFAULT_UTF8_TRUNCATOR);
                    }

                    @Override
                    public Optional<BinaryTruncator> visit(LogicalTypeAnnotation.JsonLogicalTypeAnnotation jsonLogicalType) {
                        return Optional.of(DEFAULT_UTF8_TRUNCATOR);
                    }

                    @Override
                    public Optional<BinaryTruncator> visit(LogicalTypeAnnotation.BsonLogicalTypeAnnotation bsonLogicalType) {
                        return Optional.of(DEFAULT_UTF8_TRUNCATOR);
                    }
                }).orElse(NO_OP_TRUNCATOR);
            }
        }
        throw new IllegalArgumentException("No truncator is available for the type: " + type);
    }

    public abstract Binary truncateMin(Binary var1, int var2);

    public abstract Binary truncateMax(Binary var1, int var2);

    private static class CharsetValidator {
        private final CharBuffer dummyBuffer = CharBuffer.allocate(1024);
        private final CharsetDecoder decoder;

        CharsetValidator(Charset charset) {
            this.decoder = charset.newDecoder();
            this.decoder.onMalformedInput(CodingErrorAction.REPORT);
            this.decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        }

        Validity checkValidity(ByteBuffer buffer) {
            int pos = buffer.position();
            CoderResult result = CoderResult.OVERFLOW;
            while (result.isOverflow()) {
                this.dummyBuffer.clear();
                result = this.decoder.decode(buffer, this.dummyBuffer, true);
            }
            buffer.position(pos);
            if (result.isUnderflow()) {
                return Validity.VALID;
            }
            if (result.isMalformed()) {
                return Validity.MALFORMED;
            }
            return Validity.UNMAPPABLE;
        }
    }

    static enum Validity {
        VALID,
        MALFORMED,
        UNMAPPABLE;

    }
}

