/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.column.values.factory;

import hive.org.apache.parquet.column.ColumnDescriptor;
import hive.org.apache.parquet.column.Encoding;
import hive.org.apache.parquet.column.ParquetProperties;
import hive.org.apache.parquet.column.values.ValuesWriter;
import hive.org.apache.parquet.column.values.dictionary.DictionaryValuesWriter;
import hive.org.apache.parquet.column.values.factory.DefaultV1ValuesWriterFactory;
import hive.org.apache.parquet.column.values.factory.DefaultV2ValuesWriterFactory;
import hive.org.apache.parquet.column.values.factory.ValuesWriterFactory;
import hive.org.apache.parquet.column.values.fallback.FallbackValuesWriter;

public class DefaultValuesWriterFactory
implements ValuesWriterFactory {
    private ValuesWriterFactory delegateFactory;
    private static final ValuesWriterFactory DEFAULT_V1_WRITER_FACTORY = new DefaultV1ValuesWriterFactory();
    private static final ValuesWriterFactory DEFAULT_V2_WRITER_FACTORY = new DefaultV2ValuesWriterFactory();

    @Override
    public void initialize(ParquetProperties properties) {
        this.delegateFactory = properties.getWriterVersion() == ParquetProperties.WriterVersion.PARQUET_1_0 ? DEFAULT_V1_WRITER_FACTORY : DEFAULT_V2_WRITER_FACTORY;
        this.delegateFactory.initialize(properties);
    }

    @Override
    public ValuesWriter newValuesWriter(ColumnDescriptor descriptor) {
        return this.delegateFactory.newValuesWriter(descriptor);
    }

    static DictionaryValuesWriter dictionaryWriter(ColumnDescriptor path, ParquetProperties properties, Encoding dictPageEncoding, Encoding dataPageEncoding) {
        switch (path.getType()) {
            case BOOLEAN: {
                throw new IllegalArgumentException("no dictionary encoding for BOOLEAN");
            }
            case BINARY: {
                return new DictionaryValuesWriter.PlainBinaryDictionaryValuesWriter(properties.getDictionaryPageSizeThreshold(), dataPageEncoding, dictPageEncoding, properties.getAllocator());
            }
            case INT32: {
                return new DictionaryValuesWriter.PlainIntegerDictionaryValuesWriter(properties.getDictionaryPageSizeThreshold(), dataPageEncoding, dictPageEncoding, properties.getAllocator());
            }
            case INT64: {
                return new DictionaryValuesWriter.PlainLongDictionaryValuesWriter(properties.getDictionaryPageSizeThreshold(), dataPageEncoding, dictPageEncoding, properties.getAllocator());
            }
            case INT96: {
                return new DictionaryValuesWriter.PlainFixedLenArrayDictionaryValuesWriter(properties.getDictionaryPageSizeThreshold(), 12, dataPageEncoding, dictPageEncoding, properties.getAllocator());
            }
            case DOUBLE: {
                return new DictionaryValuesWriter.PlainDoubleDictionaryValuesWriter(properties.getDictionaryPageSizeThreshold(), dataPageEncoding, dictPageEncoding, properties.getAllocator());
            }
            case FLOAT: {
                return new DictionaryValuesWriter.PlainFloatDictionaryValuesWriter(properties.getDictionaryPageSizeThreshold(), dataPageEncoding, dictPageEncoding, properties.getAllocator());
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return new DictionaryValuesWriter.PlainFixedLenArrayDictionaryValuesWriter(properties.getDictionaryPageSizeThreshold(), path.getTypeLength(), dataPageEncoding, dictPageEncoding, properties.getAllocator());
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)path.getType()));
    }

    static ValuesWriter dictWriterWithFallBack(ColumnDescriptor path, ParquetProperties parquetProperties, Encoding dictPageEncoding, Encoding dataPageEncoding, ValuesWriter writerToFallBackTo) {
        if (parquetProperties.isEnableDictionary()) {
            return FallbackValuesWriter.of(DefaultValuesWriterFactory.dictionaryWriter(path, parquetProperties, dictPageEncoding, dataPageEncoding), writerToFallBackTo);
        }
        return writerToFallBackTo;
    }
}

