/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.column.impl;

import hive.org.apache.parquet.VersionParser;
import hive.org.apache.parquet.column.ColumnDescriptor;
import hive.org.apache.parquet.column.ColumnReadStore;
import hive.org.apache.parquet.column.ColumnReader;
import hive.org.apache.parquet.column.impl.ColumnReaderImpl;
import hive.org.apache.parquet.column.impl.SynchronizingColumnReader;
import hive.org.apache.parquet.column.page.PageReadStore;
import hive.org.apache.parquet.column.page.PageReader;
import hive.org.apache.parquet.io.api.Converter;
import hive.org.apache.parquet.io.api.GroupConverter;
import hive.org.apache.parquet.io.api.PrimitiveConverter;
import hive.org.apache.parquet.schema.GroupType;
import hive.org.apache.parquet.schema.MessageType;
import hive.org.apache.parquet.schema.Type;
import java.util.Optional;
import java.util.PrimitiveIterator;

public class ColumnReadStoreImpl
implements ColumnReadStore {
    private final PageReadStore pageReadStore;
    private final GroupConverter recordConverter;
    private final MessageType schema;
    private final VersionParser.ParsedVersion writerVersion;

    public ColumnReadStoreImpl(PageReadStore pageReadStore, GroupConverter recordConverter, MessageType schema, String createdBy) {
        VersionParser.ParsedVersion version;
        this.pageReadStore = pageReadStore;
        this.recordConverter = recordConverter;
        this.schema = schema;
        try {
            version = VersionParser.parse(createdBy);
        }
        catch (RuntimeException e) {
            version = null;
        }
        catch (VersionParser.VersionParseException e) {
            version = null;
        }
        this.writerVersion = version;
    }

    @Override
    public ColumnReader getColumnReader(ColumnDescriptor path) {
        PrimitiveConverter converter = this.getPrimitiveConverter(path);
        PageReader pageReader = this.pageReadStore.getPageReader(path);
        Optional<PrimitiveIterator.OfLong> rowIndexes = this.pageReadStore.getRowIndexes();
        if (rowIndexes.isPresent()) {
            return new SynchronizingColumnReader(path, pageReader, converter, this.writerVersion, rowIndexes.get());
        }
        return new ColumnReaderImpl(path, pageReader, converter, this.writerVersion);
    }

    private ColumnReaderImpl newMemColumnReader(ColumnDescriptor path, PageReader pageReader) {
        PrimitiveConverter converter = this.getPrimitiveConverter(path);
        return new ColumnReaderImpl(path, pageReader, converter, this.writerVersion);
    }

    private PrimitiveConverter getPrimitiveConverter(ColumnDescriptor path) {
        Type currentType = this.schema;
        Converter currentConverter = this.recordConverter;
        for (String fieldName : path.getPath()) {
            GroupType groupType = currentType.asGroupType();
            int fieldIndex = groupType.getFieldIndex(fieldName);
            currentType = groupType.getType(fieldName);
            currentConverter = ((Converter)currentConverter).asGroupConverter().getConverter(fieldIndex);
        }
        PrimitiveConverter converter = currentConverter.asPrimitiveConverter();
        return converter;
    }
}

