/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.httpdlog;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.Parser;
import nl.basjes.parse.core.SimpleDissector;
import nl.basjes.parse.core.Value;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import nl.basjes.parse.httpdlog.Utils;
import nl.basjes.parse.httpdlog.dissectors.nginxmodules.CoreLogModule;
import nl.basjes.parse.httpdlog.dissectors.nginxmodules.GeoIPModule;
import nl.basjes.parse.httpdlog.dissectors.nginxmodules.KubernetesIngressModule;
import nl.basjes.parse.httpdlog.dissectors.nginxmodules.NginxModule;
import nl.basjes.parse.httpdlog.dissectors.nginxmodules.SslModule;
import nl.basjes.parse.httpdlog.dissectors.nginxmodules.UpstreamModule;
import nl.basjes.parse.httpdlog.dissectors.nginxmodules.VariousModule;
import nl.basjes.parse.httpdlog.dissectors.tokenformat.TokenFormatDissector;
import nl.basjes.parse.httpdlog.dissectors.tokenformat.TokenParser;
import nl.basjes.parse.httpdlog.dissectors.translate.ConvertMillisecondsIntoMicroseconds;
import nl.basjes.parse.httpdlog.dissectors.translate.ConvertSecondsWithMillisStringDissector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NginxHttpdLogFormatDissector
extends TokenFormatDissector {
    private static final Logger LOG = LoggerFactory.getLogger(NginxHttpdLogFormatDissector.class);
    private static final List<NginxModule> MODULES = new ArrayList<NginxModule>();

    public NginxHttpdLogFormatDissector(String logFormat) {
        super(logFormat);
        this.setInputType("HTTPLOGLINE");
    }

    public NginxHttpdLogFormatDissector() {
        this.setInputType("HTTPLOGLINE");
    }

    private void overrideLogFormat(String originalLogformat, String logformat) {
        LOG.debug("Specified logformat \"{}\" was mapped to {}", (Object)originalLogformat, (Object)logformat);
        super.setLogFormat(logformat);
    }

    @Override
    public void setLogFormat(String logformat) {
        switch (logformat.toLowerCase(Locale.getDefault())) {
            case "combined": {
                this.overrideLogFormat(logformat, "$remote_addr - $remote_user [$time_local] \"$request\" $status $body_bytes_sent \"$http_referer\" \"$http_user_agent\"");
                break;
            }
            default: {
                super.setLogFormat(logformat);
            }
        }
    }

    public static boolean looksLikeNginxFormat(String logFormat) {
        if (logFormat.indexOf(36) != -1) {
            return true;
        }
        switch (logFormat.toLowerCase(Locale.getDefault())) {
            case "combined": {
                return true;
            }
        }
        return false;
    }

    @Override
    public String decodeExtractedValue(String tokenName, String value) {
        if (value == null || value.equals("")) {
            return value;
        }
        if (value.equals("-")) {
            return null;
        }
        return value;
    }

    @Override
    protected List<TokenParser> createAllTokenParsers() {
        ArrayList<TokenParser> parsers = new ArrayList<TokenParser>();
        MODULES.forEach(m -> parsers.addAll(m.getTokenParsers()));
        return parsers;
    }

    @Override
    public <RECORD> void createAdditionalDissectors(Parser<RECORD> parser) {
        super.createAdditionalDissectors(parser);
        parser.addDissector((Dissector)new BinaryIPDissector());
        parser.addDissector((Dissector)new ConvertSecondsWithMillisStringDissector("SECOND_MILLIS", "MILLISECONDS"));
        parser.addDissector((Dissector)new ConvertSecondsWithMillisStringDissector("TIME.EPOCH_SECOND_MILLIS", "TIME.EPOCH"));
        parser.addDissector((Dissector)new ConvertMillisecondsIntoMicroseconds("MILLISECONDS", "MICROSECONDS"));
        MODULES.forEach(m -> parser.addDissectors(m.getDissectors()));
    }

    static {
        MODULES.add(new CoreLogModule());
        MODULES.add(new UpstreamModule());
        MODULES.add(new SslModule());
        MODULES.add(new GeoIPModule());
        MODULES.add(new VariousModule());
        MODULES.add(new KubernetesIngressModule());
    }

    @Deprecated
    public static class NotYetImplemented
    extends TokenFormatDissector.NotImplementedTokenParser {
        private static final String FIELD_PREFIX = "nginx_parameter";

        public NotYetImplemented(String nLogFormatToken) {
            super(nLogFormatToken, FIELD_PREFIX, 0);
        }

        public NotYetImplemented(String nLogFormatToken, String regex) {
            super(nLogFormatToken, FIELD_PREFIX, regex, 0);
        }

        public NotYetImplemented(String nLogFormatToken, String regex, int prio) {
            super(nLogFormatToken, FIELD_PREFIX, regex, prio);
        }

        public NotYetImplemented(String nLogFormatToken, int prio) {
            super(nLogFormatToken, FIELD_PREFIX, "[^\" ]*", prio);
        }
    }

    public static class BinaryIPDissector
    extends SimpleDissector {
        private static final HashMap<String, EnumSet<Casts>> EPOCH_MILLIS_CONFIG = new HashMap();
        private static final String CAPTURE_HEX_BYTE = "\\\\x([0-9a-fA-F][0-9a-fA-F])";
        final Pattern binaryIPPattern = Pattern.compile("\\\\x([0-9a-fA-F][0-9a-fA-F])\\\\x([0-9a-fA-F][0-9a-fA-F])\\\\x([0-9a-fA-F][0-9a-fA-F])\\\\x([0-9a-fA-F][0-9a-fA-F])");

        public BinaryIPDissector() {
            super("IP_BINARY", EPOCH_MILLIS_CONFIG);
        }

        public void dissect(Parsable<?> parsable, String inputname, Value value) throws DissectionFailure {
            Matcher matcher = this.binaryIPPattern.matcher(value.getString());
            if (matcher.matches()) {
                String ip = String.valueOf(Utils.hexCharsToByte(matcher.group(1))) + '.' + String.valueOf(Utils.hexCharsToByte(matcher.group(2))) + '.' + String.valueOf(Utils.hexCharsToByte(matcher.group(3))) + '.' + String.valueOf(Utils.hexCharsToByte(matcher.group(4)));
                parsable.addDissection(inputname, "IP", "", ip);
            }
        }

        static {
            EPOCH_MILLIS_CONFIG.put("IP:", Casts.STRING_OR_LONG);
        }
    }
}

