/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.hdfs.store;

import com.google.common.base.Supplier;
import com.oracle.bmc.hdfs.store.BmcFSInputStream;
import com.oracle.bmc.objectstorage.ObjectStorage;
import com.oracle.bmc.objectstorage.requests.GetObjectRequest;
import com.oracle.bmc.util.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;

public class BmcInMemoryFSInputStream
extends BmcFSInputStream {
    public BmcInMemoryFSInputStream(ObjectStorage objectStorage, FileStatus status, Supplier<GetObjectRequest.Builder> requestBuilder, FileSystem.Statistics statistics) {
        super(objectStorage, status, requestBuilder, statistics);
    }

    @Override
    protected long doSeek(long position) throws IOException {
        super.validateState(0L);
        InputStream sourceInputStream = super.getSourceInputStream();
        sourceInputStream.reset();
        return sourceInputStream.skip(position);
    }

    @Override
    protected InputStream wrap(InputStream rawInputStream) throws IOException {
        return StreamUtils.createByteArrayInputStream((byte[])IOUtils.toByteArray((InputStream)rawInputStream));
    }
}

