/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.hdfs.caching;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.hdfs.caching.Cache;
import com.oracle.bmc.hdfs.caching.CacheBuilder;
import com.oracle.bmc.hdfs.caching.CacheBuilderWithWeight;
import com.oracle.bmc.hdfs.caching.ConsistencyPolicy;
import com.oracle.bmc.hdfs.caching.StrongConsistencyPolicy;
import com.oracle.bmc.hdfs.caching.internal.BufferedInputStreamMultiplexer;
import com.oracle.bmc.hdfs.caching.internal.GuavaCacheBuilder;
import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.objectstorage.ObjectStorage;
import com.oracle.bmc.objectstorage.requests.GetObjectRequest;
import com.oracle.bmc.objectstorage.responses.GetObjectResponse;
import com.oracle.bmc.objectstorage.transfer.DownloadConfiguration;
import com.oracle.bmc.objectstorage.transfer.DownloadManager;
import java.beans.ConstructorProperties;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface CachingObjectStorage
extends ObjectStorage {
    public static Configuration.ConfigurationBuilder newConfiguration() {
        return Configuration.builder();
    }

    public static CachingObjectStorage build(Configuration config) {
        Objects.requireNonNull(config.client, "must provide ObjectStorage client to client to");
        Objects.requireNonNull(config.downloadConfiguration, "must provide ObjectdownloadConfiguration");
        Objects.requireNonNull(config.cacheDirectory, "must provide cache directory");
        Objects.requireNonNull(config.consistencyPolicy, "must provide consistency policy");
        Objects.requireNonNull(config.deletionExecutor, "must provide deletion executor");
        Objects.requireNonNull(config.uncacheablePredicate, "must provide uncacheable predicate");
        Objects.requireNonNull(config.downloadExecutor, "must provide download executor");
        Objects.requireNonNull(config.rowLockProvider, "must provide row lock provider");
        Objects.requireNonNull(config.cacheGarbageCollection, "must provide cacheGarbageCollection");
        return CachingObjectStorage.build(config.client, config.downloadConfiguration, config.cacheDirectory, config.downloadExecutor, config.uncacheablePredicate, config.consistencyPolicy, ((GuavaCacheBuilder)new GuavaCacheBuilder().concurrencyLevel(config.concurrencyLevel).expireAfterAccess(config.expireAfterAccess).expireAfterWrite(config.expireAfterWrite).initialCapacity(config.initialCapacity).maximumSize(config.maximumSize).maximumWeight(config.maximumWeight)).recordStats(config.recordStats), config.deletionExecutor, config.rowLockProvider, config.cacheGarbageCollection);
    }

    public static CachingObjectStorage build(ObjectStorage client, DownloadConfiguration downloadConfiguration, Path cacheDirectory, ExecutorService downloadExecutor, UncacheablePredicate uncacheablePredicate, ConsistencyPolicy consistencyPolicy, CacheBuilder<GetObjectRequestCacheKey, GetObjectResponseCacheValue, ?> cacheBuilder, ExecutorService deletionExecutor, RowLockProvider rowLockProvider, Runnable cacheGarbageCollection) {
        return (CachingObjectStorage)Proxy.newProxyInstance(CachingObjectStorage.class.getClassLoader(), new Class[]{CachingObjectStorage.class}, (InvocationHandler)new Handler(client, downloadConfiguration, cacheDirectory, downloadExecutor, uncacheablePredicate, consistencyPolicy, cacheBuilder, deletionExecutor, rowLockProvider, cacheGarbageCollection));
    }

    public GetObjectResponse getObjectUncached(GetObjectRequest var1);

    public void cleanUp();

    public Set<Path> getEvictedButNotDeleted();

    public Cache.Statistics getCacheStatistics();

    public void prepopulateCache(GetObjectRequest var1, GetObjectResponse var2);

    public static class DefaultRowLockProvider
    implements RowLockProvider {
        private ReentrantLock[] locks;

        public DefaultRowLockProvider(int size) {
            this.locks = new ReentrantLock[size];
            for (int i = 0; i < size; ++i) {
                this.locks[i] = new ReentrantLock();
            }
        }

        @Override
        public RowLock lock(GetObjectRequestCacheKey key) {
            int lockIndex = Math.abs(key.hashCode() % this.locks.length);
            ReentrantLock lock = this.locks[lockIndex];
            lock.lock();
            return new RowLock(lock, lockIndex);
        }
    }

    public static interface RowLockProvider {
        public RowLock lock(GetObjectRequestCacheKey var1);
    }

    public static class RowLock
    implements AutoCloseable {
        private final ReentrantLock lock;
        private final int lockIndex;

        @Override
        public void close() {
            this.lock.unlock();
        }

        public String toString() {
            return "RowLock{lockIndex=" + this.lockIndex + '}';
        }

        @ConstructorProperties(value={"lock", "lockIndex"})
        public RowLock(ReentrantLock lock, int lockIndex) {
            this.lock = lock;
            this.lockIndex = lockIndex;
        }
    }

    public static class DefaultUncacheablePredicate
    implements UncacheablePredicate {
        @Override
        public boolean test(GetObjectRequest getObjectRequest) {
            return getObjectRequest.getIfNoneMatch() != null;
        }
    }

    public static interface UncacheablePredicate
    extends Predicate<GetObjectRequest> {
    }

    public static class RemovalListener
    implements Cache.RemovalListener<GetObjectRequestCacheKey, GetObjectResponseCacheValue> {
        private static final Logger LOG = LoggerFactory.getLogger(RemovalListener.class);
        private final Handler handler;

        public RemovalListener(Handler handler) {
            this.handler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemoval(Cache.RemovalNotification<GetObjectRequestCacheKey, GetObjectResponseCacheValue> removalNotification) {
            LOG.debug("Removed object content cache entry '{}' ('{}')", removalNotification.getKey(), (Object)removalNotification.toString());
            Path cachedContent = ((GetObjectResponseCacheValue)removalNotification.getValue()).cachedContent.getPath();
            if (cachedContent != null) {
                Set set = this.handler.evictedButNotDeleted;
                synchronized (set) {
                    this.handler.evictedButNotDeleted.add(cachedContent);
                }
            }
            this.handler.cacheGarbageCollection.run();
        }
    }

    public static class DeletionRunnable
    implements Runnable {
        private static final Logger LOG = LoggerFactory.getLogger(DeletionRunnable.class);
        private final Handler handler;

        public DeletionRunnable(Handler handler) {
            this.handler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.handler.isShutDown) {
                LOG.trace("Deletion loop is running");
                try {
                    Reference referenceFromQueue = this.handler.referenceQueue.remove();
                    if (referenceFromQueue == null) continue;
                    PathPhantomReference reference = (PathPhantomReference)referenceFromQueue;
                    LOG.debug("Dequeued reference in deletion loop: " + reference.cachedContentPath);
                    long dataSizeInBytes = this.deleteCachedFile(reference);
                    Object object = this.handler;
                    synchronized (object) {
                        Handler handler = this.handler;
                        handler.diskSpaceUsedInBytes = handler.diskSpaceUsedInBytes - dataSizeInBytes;
                        LOG.info("Freed {} bytes, cache size is now {} bytes", (Object)dataSizeInBytes, (Object)this.handler.diskSpaceUsedInBytes);
                    }
                    referenceFromQueue.clear();
                    object = this.handler.phantomReferences;
                    synchronized (object) {
                        this.handler.phantomReferences.remove(referenceFromQueue);
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
            LOG.debug("Exiting deletion loop due to cache shutdown");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long deleteCachedFile(PathPhantomReference reference) {
            Path cachedContentPath = reference.getCachedContentPath();
            if (cachedContentPath != null) {
                try {
                    Files.deleteIfExists(cachedContentPath);
                    Set set = this.handler.evictedButNotDeleted;
                    synchronized (set) {
                        this.handler.evictedButNotDeleted.remove(cachedContentPath);
                    }
                    LOG.debug("Deleted cached file '{}'", (Object)cachedContentPath);
                    return reference.getDataSizeInBytes();
                }
                catch (IOException ioe) {
                    LOG.error("Failed to delete cached file '{}'", (Object)cachedContentPath, (Object)ioe);
                    return 0L;
                }
            }
            return 0L;
        }
    }

    public static final class PathHolder {
        private final Path path;

        public File toFile() {
            return this.path.toFile();
        }

        @ConstructorProperties(value={"path"})
        public PathHolder(Path path) {
            this.path = path;
        }

        public Path getPath() {
            return this.path;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PathHolder)) {
                return false;
            }
            PathHolder other = (PathHolder)o;
            Path this$path = this.getPath();
            Path other$path = other.getPath();
            return !(this$path == null ? other$path != null : !((Object)this$path).equals(other$path));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Path $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
            return result;
        }

        public String toString() {
            return "CachingObjectStorage.PathHolder(path=" + this.getPath() + ")";
        }
    }

    public static class PathPhantomReference
    extends PhantomReference<PathHolder> {
        private static final Logger LOG = LoggerFactory.getLogger(PathPhantomReference.class);
        final Path cachedContentPath;
        final long dataSizeInBytes;
        volatile boolean isCleared = false;

        public PathPhantomReference(PathHolder referent, ReferenceQueue<? super PathHolder> q, long dataSizeInBytes) {
            super(referent, q);
            this.cachedContentPath = referent.getPath();
            this.dataSizeInBytes = dataSizeInBytes;
        }

        @Override
        public void clear() {
            super.clear();
            this.isCleared = true;
        }

        public String toString() {
            return "PathPhantomReference{cachedContentPath='" + this.cachedContentPath + '\'' + ", dataSizeInBytes='" + this.dataSizeInBytes + "', isCleared='" + this.isCleared + "', isEnqueued='" + this.isEnqueued() + "'}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PathPhantomReference that = (PathPhantomReference)o;
            return Objects.equals(this.cachedContentPath, that.cachedContentPath);
        }

        public int hashCode() {
            return Objects.hash(this.cachedContentPath);
        }

        public Path getCachedContentPath() {
            return this.cachedContentPath;
        }

        public long getDataSizeInBytes() {
            return this.dataSizeInBytes;
        }

        public boolean isCleared() {
            return this.isCleared;
        }
    }

    public static class CachedInputStream
    extends BufferedInputStream {
        private static final Logger LOG = LoggerFactory.getLogger(CachedInputStream.class);
        private final Path cachedContentPath;
        private volatile PathHolder cachedContent;

        public CachedInputStream(PathHolder cachedContent, InputStream muxInputStream) {
            super(muxInputStream);
            this.cachedContent = Objects.requireNonNull(cachedContent, "cachedContent must be non-null");
            this.cachedContentPath = cachedContent.getPath();
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.clearCachedContent();
        }

        private void clearCachedContent() {
            this.cachedContent = null;
            LOG.trace("Closed stream, clearing cachedContent for '{}' to allow garbage collection", (Object)this.cachedContentPath);
        }

        @Override
        public synchronized int read() throws IOException {
            if (this.cachedContent == null) {
                return -1;
            }
            int read = super.read();
            if (read == -1) {
                this.close();
            }
            return read;
        }

        @Override
        public synchronized int read(byte[] b, int off, int len) throws IOException {
            if (this.cachedContent == null) {
                return -1;
            }
            int read = super.read(b, off, len);
            if (read == -1) {
                this.close();
            }
            return read;
        }

        @Override
        public int read(byte[] b) throws IOException {
            if (this.cachedContent == null) {
                return -1;
            }
            int read = super.read(b);
            if (read == -1) {
                this.close();
            }
            return read;
        }

        public Path getCachedContentPath() {
            return this.cachedContentPath;
        }
    }

    public static class GetObjectResponseCacheValue {
        private static final Logger LOG = LoggerFactory.getLogger(GetObjectResponseCacheValue.class);
        private final Handler handler;
        private final GetObjectResponse originalResponse;
        private final PathHolder cachedContent;
        private final BufferedInputStreamMultiplexer mux;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GetObjectResponseCacheValue(Handler handler, GetObjectResponse response, Path cachedContentPath) throws IOException {
            this.handler = handler;
            this.originalResponse = response;
            this.cachedContent = new PathHolder(cachedContentPath);
            if (this.cachedContent != null) {
                File cachedContentFile = this.cachedContent.getPath().toFile();
                cachedContentFile.getParentFile().mkdirs();
                PathPhantomReference pathPhantomReference = new PathPhantomReference(this.cachedContent, handler.referenceQueue, response.getContentLength());
                Set set = handler.phantomReferences;
                synchronized (set) {
                    handler.phantomReferences.add(pathPhantomReference);
                    LOG.trace("Phantom reference # {}: {}", (Object)handler.phantomReferences.size(), (Object)pathPhantomReference);
                }
                BufferedInputStreamMultiplexer.FileBuffer buf = new BufferedInputStreamMultiplexer.FileBuffer(cachedContentFile);
                this.mux = new BufferedInputStreamMultiplexer(response.getInputStream(), buf);
                BufferedInputStreamMultiplexer.MultiplexerInputStream firstInputStream = this.mux.getInputStream();
                Future<?> future = handler.downloadExecutor.submit(() -> {
                    long length;
                    try {
                        LOG.debug("Starting to retrieve contents for cache file '{}' ({} bytes expected)", (Object)cachedContentFile, (Object)response.getContentLength());
                        IOUtils.copy((InputStream)firstInputStream, (OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
                        length = cachedContentFile.length();
                        LOG.debug("Retrieved contents for cache file '{}' ({} bytes)", (Object)cachedContentFile, (Object)length);
                    }
                    catch (IOException ioe) {
                        length = cachedContentFile.length();
                        LOG.error("Failed to retrieve contents cache file '{}' ({} bytes)", new Object[]{cachedContentFile, length, ioe});
                    }
                    Handler handler2 = handler;
                    synchronized (handler2) {
                        handler.diskSpaceUsedInBytes = handler.diskSpaceUsedInBytes + length;
                        LOG.info("Cache size is now {} bytes", (Object)handler.diskSpaceUsedInBytes);
                    }
                });
            } else {
                this.mux = null;
            }
        }

        public GetObjectResponse getResponse() {
            if (this.mux != null) {
                try {
                    CachedInputStream inputStream = new CachedInputStream(this.cachedContent, this.mux.getInputStream());
                    LOG.debug("Reusing cached content at " + this.cachedContent);
                    return GetObjectResponse.builder().copy(this.originalResponse).inputStream((InputStream)inputStream).build();
                }
                catch (IOException ioe) {
                    throw new BmcException(false, "Failed to use cached content at " + this.cachedContent, (Throwable)ioe, this.originalResponse.getOpcClientRequestId());
                }
            }
            return this.originalResponse;
        }

        public String toString() {
            return "GetObjectResponseCacheValue{cachedContent=" + this.cachedContent + '}';
        }

        public GetObjectResponse getOriginalResponse() {
            return this.originalResponse;
        }
    }

    public static class GetObjectRequestCacheKey {
        private static final Predicate<Method> gettersOnlyPredicate = m -> m.getName().startsWith("get") && m.getParameterCount() == 0 && Modifier.isPublic(m.getModifiers());
        private static final Predicate<Method> ignoreSomeGettersPredicate = m -> !m.getName().equals("getOpcClientRequestId") && !m.getName().equals("getBody$") && !m.getName().equals("getInvocationCallback") && !m.getName().equals("getRetryConfiguration") && !m.getName().equals("getClass");
        private static final Map<String, Function<Object, Object>> specialEqualsHashCodeRegistry = new HashMap<String, Function<Object, Object>>();
        private final GetObjectRequest request;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GetObjectRequestCacheKey that = (GetObjectRequestCacheKey)o;
            return !Arrays.stream(GetObjectRequest.class.getDeclaredMethods()).filter(gettersOnlyPredicate).filter(ignoreSomeGettersPredicate).anyMatch(m -> {
                try {
                    Object thisValue = m.invoke((Object)this.request, new Object[0]);
                    Object thatValue = m.invoke((Object)that.request, new Object[0]);
                    Function<Object, Object> specialEqualsHashCode = specialEqualsHashCodeRegistry.get(m.getName());
                    if (specialEqualsHashCode != null) {
                        thisValue = specialEqualsHashCode.apply(thisValue);
                        thatValue = specialEqualsHashCode.apply(thatValue);
                    }
                    return !Objects.equals(thisValue, thatValue);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException("Unexpected exception while comparing GetObjectRequest instances", e);
                }
            });
        }

        public int hashCode() {
            ArrayList objects = new ArrayList();
            objects.addAll(Arrays.stream(GetObjectRequest.class.getDeclaredMethods()).filter(gettersOnlyPredicate).filter(ignoreSomeGettersPredicate).map(m -> {
                try {
                    Object thisValue = m.invoke((Object)this.request, new Object[0]);
                    Function<Object, Object> specialEqualsHashCode = specialEqualsHashCodeRegistry.get(m.getName());
                    if (specialEqualsHashCode != null) {
                        thisValue = specialEqualsHashCode.apply(thisValue);
                    }
                    return thisValue;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException("Unexpected exception while computing GetObjectRequest hashCode", e);
                }
            }).collect(Collectors.toList()));
            return Objects.hash(objects.toArray());
        }

        public String toString() {
            String s = Arrays.stream(GetObjectRequest.class.getDeclaredMethods()).filter(gettersOnlyPredicate).filter(ignoreSomeGettersPredicate).map(m -> {
                String name = m.getName().substring(3);
                name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
                try {
                    return name + "='" + m.invoke((Object)this.request, new Object[0]) + "'";
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    return name + "=<" + e.getClass().getSimpleName() + " while getting value>";
                }
            }).collect(Collectors.joining(", "));
            return "GetObjectRequestCacheKey{" + s + "}";
        }

        @ConstructorProperties(value={"request"})
        public GetObjectRequestCacheKey(GetObjectRequest request) {
            specialEqualsHashCodeRegistry.put("getRange", o -> o != null ? o.toString() : null);
            this.request = request;
        }

        public GetObjectRequest getRequest() {
            return this.request;
        }
    }

    public static class Handler
    implements InvocationHandler {
        private static final Logger LOG = LoggerFactory.getLogger(Handler.class);
        private final ObjectStorage client;
        private final DownloadManager downloadManager;
        private final Cache<GetObjectRequestCacheKey, GetObjectResponseCacheValue> getObjectCache;
        private final Path cacheDirectory;
        private final ExecutorService downloadExecutor;
        private final UncacheablePredicate uncacheablePredicate;
        private final ConsistencyPolicy consistencyPolicy;
        private final RowLockProvider rowLockProvider;
        private volatile boolean isShutDown = false;
        private final DeletionRunnable deletionRunnable;
        private final Future<?> deletionFuture;
        private final ReferenceQueue<PathHolder> referenceQueue = new ReferenceQueue();
        private final Set<PathPhantomReference> phantomReferences = new LinkedHashSet<PathPhantomReference>();
        private final Set<Path> evictedButNotDeleted = new HashSet<Path>();
        private volatile long diskSpaceUsedInBytes = 0L;
        private final Long maximumWeightInBytes;
        private final Runnable cacheGarbageCollection;

        public Handler(ObjectStorage client, DownloadConfiguration downloadConfiguration, Path cacheDirectory, ExecutorService downloadExecutor, UncacheablePredicate uncacheablePredicate, ConsistencyPolicy consistencyPolicy, CacheBuilder<GetObjectRequestCacheKey, GetObjectResponseCacheValue, ?> cacheBuilder, ExecutorService deletionExecutor, RowLockProvider rowLockProvider, Runnable cacheGarbageCollection) {
            this.client = client;
            this.downloadManager = new DownloadManager(client, downloadConfiguration);
            this.cacheDirectory = cacheDirectory;
            this.cacheDirectory.toFile().mkdirs();
            this.downloadExecutor = downloadExecutor;
            this.uncacheablePredicate = uncacheablePredicate;
            this.consistencyPolicy = consistencyPolicy;
            this.rowLockProvider = rowLockProvider;
            this.cacheGarbageCollection = cacheGarbageCollection;
            this.deletionRunnable = new DeletionRunnable(this);
            this.deletionFuture = deletionExecutor.submit(this.deletionRunnable);
            RemovalListener removalListener = new RemovalListener(this);
            Cache.Weigher<GetObjectRequestCacheKey, GetObjectResponseCacheValue> weighByLength = (key, value) -> {
                Long contentLength = ((GetObjectResponseCacheValue)value).originalResponse.getContentLength();
                if (contentLength == null) {
                    contentLength = ((GetObjectResponseCacheValue)value).cachedContent != null ? Long.valueOf(((GetObjectResponseCacheValue)value).cachedContent.getPath().toFile().length()) : Long.valueOf(0L);
                }
                if (contentLength > Integer.MAX_VALUE) {
                    contentLength = Integer.MAX_VALUE;
                }
                LOG.debug("Weight for '{}' is '{}'", (Object)((GetObjectResponseCacheValue)value).cachedContent, (Object)contentLength);
                return contentLength.intValue();
            };
            cacheBuilder = cacheBuilder.removalListener(removalListener);
            if (cacheBuilder instanceof CacheBuilderWithWeight) {
                Long maximumWeightInBytes;
                this.maximumWeightInBytes = maximumWeightInBytes = ((CacheBuilderWithWeight)cacheBuilder).getMaximumWeight();
                if (maximumWeightInBytes != null) {
                    cacheBuilder = cacheBuilder.weigher(weighByLength);
                }
            } else {
                this.maximumWeightInBytes = null;
            }
            this.getObjectCache = cacheBuilder.build();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            switch (method.getName()) {
                case "getObject": {
                    return this.getObject((GetObjectRequest)args[0]);
                }
                case "getObjectUncached": {
                    return this.getObjectUncached((GetObjectRequest)args[0]);
                }
                case "prepopulateCache": {
                    this.prepopulateCache((GetObjectRequest)args[0], (GetObjectResponse)args[1]);
                    return null;
                }
                case "cleanUp": {
                    this.cleanUp();
                    return null;
                }
                case "getEvictedButNotDeleted": {
                    return this.getEvictedButNotDeleted();
                }
                case "getCacheStatistics": {
                    return this.getCacheStatistics();
                }
                case "close": {
                    this.close();
                    return null;
                }
            }
            try {
                return method.invoke((Object)this.client, args);
            }
            catch (InvocationTargetException ite) {
                throw ite.getCause();
            }
        }

        /*
         * Exception decompiling
         */
        protected GetObjectResponse getObject(GetObjectRequest getObjectRequest) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 24[SIMPLE_IF_TAKEN]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void prepopulateCache(GetObjectRequest cacheRequest, GetObjectResponse cacheResponse) {
            if (cacheRequest == null || cacheResponse == null) {
                LOG.debug("Cannot prepopulate cache with null values. Request: {}, Response: {}", (Object)cacheRequest, (Object)cacheResponse);
                return;
            }
            if (this.uncacheablePredicate.test(cacheRequest)) {
                LOG.debug("Request is uncacheable: {}", (Object)cacheRequest);
                return;
            }
            GetObjectRequestCacheKey key = this.consistencyPolicy.constructKey(cacheRequest);
            try (RowLock lock = this.rowLockProvider.lock(key);){
                LOG.trace("Acquired lock on key '{}'", (Object)key);
                GetObjectResponseCacheValue value = this.getObjectCache.getIfPresent(key);
                if (value != null) {
                    LOG.warn("Replacing cache value for request: {}.", (Object)cacheRequest);
                    value = null;
                    this.getObjectCache.invalidate(key);
                }
                if (this.maximumWeightInBytes != null && this.diskSpaceUsedInBytes >= this.maximumWeightInBytes) {
                    LOG.warn("Not caching request, cache size '{}' already at maximum '{}' weight", (Object)this.diskSpaceUsedInBytes, (Object)this.maximumWeightInBytes);
                } else {
                    value = this.load(key, cacheResponse);
                    this.getObjectCache.put(key, value);
                }
            }
            finally {
                LOG.trace("Released lock on key '{}'", (Object)key);
            }
        }

        static GetObjectRequest.Builder updateRequestId(GetObjectRequest.Builder builder, GetObjectRequest getObjectRequest) {
            if (getObjectRequest.getOpcClientRequestId() != null) {
                String clientRequestId = getObjectRequest.getOpcClientRequestId() + "-" + System.currentTimeMillis();
                LOG.trace("Instead of client-provided opcClientRequestId '{}', using opcClientRequestId '{}'", (Object)getObjectRequest.getOpcClientRequestId(), (Object)clientRequestId);
                builder = builder.opcClientRequestId(clientRequestId);
            }
            return builder;
        }

        protected GetObjectResponse getObjectUncached(GetObjectRequest getObjectRequest) {
            GetObjectResponse response = this.client.getObject(getObjectRequest);
            return response;
        }

        protected void cleanUp() {
            this.getObjectCache.cleanUp();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Set<Path> getEvictedButNotDeleted() {
            Set<Path> set = this.evictedButNotDeleted;
            synchronized (set) {
                return Collections.unmodifiableSet(new HashSet<Path>(this.evictedButNotDeleted));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @InternalSdk
        protected Set<? extends PhantomReference> getPhantomReferences() {
            Set<PathPhantomReference> set = this.phantomReferences;
            synchronized (set) {
                return Collections.unmodifiableSet(this.phantomReferences);
            }
        }

        protected Cache.Statistics getCacheStatistics() {
            return this.getObjectCache.getStatistics();
        }

        protected void close() throws Exception {
            this.client.close();
            this.isShutDown = true;
            this.deletionFuture.cancel(true);
        }

        private GetObjectResponseCacheValue load(GetObjectRequestCacheKey key, GetObjectResponse getObjectResponse) {
            Path cachedContent = null;
            try {
                if (getObjectResponse.getInputStream() != null) {
                    cachedContent = Files.createTempFile(this.cacheDirectory, String.format("%08x-", this.hashCode()), ".tmp", new FileAttribute[0]);
                    cachedContent.toFile().deleteOnExit();
                    LOG.debug("Retrieving contents for '{}' to store at '{}' (expecting {} bytes)", new Object[]{key, cachedContent, getObjectResponse.getContentLength()});
                }
                GetObjectResponseCacheValue cacheValue = new GetObjectResponseCacheValue(this, getObjectResponse, cachedContent);
                if (getObjectResponse.getInputStream() != null) {
                    LOG.debug("Retrieved contents for '{}' and stored them at '{}'", (Object)key, cachedContent);
                } else {
                    LOG.debug("Retrieved contents for '{}', was null response", (Object)key);
                }
                return cacheValue;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }

    public static class Configuration {
        private static final Logger LOG = LoggerFactory.getLogger(Configuration.class);
        private ObjectStorage client;
        private DownloadConfiguration downloadConfiguration;
        private Path cacheDirectory;
        private Integer initialCapacity;
        private boolean recordStats;
        private Integer maximumSize;
        private Long maximumWeight;
        private Integer concurrencyLevel;
        private Duration expireAfterAccess;
        private Duration expireAfterWrite;
        private ConsistencyPolicy consistencyPolicy;
        private ExecutorService downloadExecutor;
        private ExecutorService deletionExecutor;
        private UncacheablePredicate uncacheablePredicate;
        private RowLockProvider rowLockProvider;
        private Runnable cacheGarbageCollection;

        private static DownloadConfiguration $default$downloadConfiguration() {
            return DownloadConfiguration.builder().parallelDownloads(1).build();
        }

        private static Integer $default$initialCapacity() {
            return 16;
        }

        private static boolean $default$recordStats() {
            return false;
        }

        private static Integer $default$maximumSize() {
            return null;
        }

        private static Long $default$maximumWeight() {
            return null;
        }

        private static Integer $default$concurrencyLevel() {
            return 1;
        }

        private static Duration $default$expireAfterAccess() {
            return null;
        }

        private static Duration $default$expireAfterWrite() {
            return null;
        }

        private static ConsistencyPolicy $default$consistencyPolicy() {
            return new StrongConsistencyPolicy();
        }

        private static ExecutorService $default$downloadExecutor() {
            return new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat(CachingObjectStorage.class.getSimpleName() + "-download-%d").build());
        }

        private static ExecutorService $default$deletionExecutor() {
            return Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat(CachingObjectStorage.class.getSimpleName() + "-deletion-%d").build());
        }

        private static UncacheablePredicate $default$uncacheablePredicate() {
            return new DefaultUncacheablePredicate();
        }

        private static RowLockProvider $default$rowLockProvider() {
            return new DefaultRowLockProvider(1024);
        }

        private static Runnable $default$cacheGarbageCollection() {
            return () -> {};
        }

        @ConstructorProperties(value={"client", "downloadConfiguration", "cacheDirectory", "initialCapacity", "recordStats", "maximumSize", "maximumWeight", "concurrencyLevel", "expireAfterAccess", "expireAfterWrite", "consistencyPolicy", "downloadExecutor", "deletionExecutor", "uncacheablePredicate", "rowLockProvider", "cacheGarbageCollection"})
        Configuration(ObjectStorage client, DownloadConfiguration downloadConfiguration, Path cacheDirectory, Integer initialCapacity, boolean recordStats, Integer maximumSize, Long maximumWeight, Integer concurrencyLevel, Duration expireAfterAccess, Duration expireAfterWrite, ConsistencyPolicy consistencyPolicy, ExecutorService downloadExecutor, ExecutorService deletionExecutor, UncacheablePredicate uncacheablePredicate, RowLockProvider rowLockProvider, Runnable cacheGarbageCollection) {
            this.client = client;
            this.downloadConfiguration = downloadConfiguration;
            this.cacheDirectory = cacheDirectory;
            this.initialCapacity = initialCapacity;
            this.recordStats = recordStats;
            this.maximumSize = maximumSize;
            this.maximumWeight = maximumWeight;
            this.concurrencyLevel = concurrencyLevel;
            this.expireAfterAccess = expireAfterAccess;
            this.expireAfterWrite = expireAfterWrite;
            this.consistencyPolicy = consistencyPolicy;
            this.downloadExecutor = downloadExecutor;
            this.deletionExecutor = deletionExecutor;
            this.uncacheablePredicate = uncacheablePredicate;
            this.rowLockProvider = rowLockProvider;
            this.cacheGarbageCollection = cacheGarbageCollection;
        }

        public static ConfigurationBuilder builder() {
            return new ConfigurationBuilder();
        }

        public static class ConfigurationBuilder {
            private ObjectStorage client;
            private boolean downloadConfiguration$set;
            private DownloadConfiguration downloadConfiguration$value;
            private Path cacheDirectory;
            private boolean initialCapacity$set;
            private Integer initialCapacity$value;
            private boolean recordStats$set;
            private boolean recordStats$value;
            private boolean maximumSize$set;
            private Integer maximumSize$value;
            private boolean maximumWeight$set;
            private Long maximumWeight$value;
            private boolean concurrencyLevel$set;
            private Integer concurrencyLevel$value;
            private boolean expireAfterAccess$set;
            private Duration expireAfterAccess$value;
            private boolean expireAfterWrite$set;
            private Duration expireAfterWrite$value;
            private boolean consistencyPolicy$set;
            private ConsistencyPolicy consistencyPolicy$value;
            private boolean downloadExecutor$set;
            private ExecutorService downloadExecutor$value;
            private boolean deletionExecutor$set;
            private ExecutorService deletionExecutor$value;
            private boolean uncacheablePredicate$set;
            private UncacheablePredicate uncacheablePredicate$value;
            private boolean rowLockProvider$set;
            private RowLockProvider rowLockProvider$value;
            private boolean cacheGarbageCollection$set;
            private Runnable cacheGarbageCollection$value;

            public ConfigurationBuilder aggressiveCacheGarbageCollection(int sleepMillis) {
                return this.cacheGarbageCollection(() -> {
                    LOG.info("Aggressive garbage collection");
                    System.gc();
                    try {
                        TimeUnit.MILLISECONDS.sleep(sleepMillis);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                });
            }

            ConfigurationBuilder() {
            }

            public ConfigurationBuilder client(ObjectStorage client) {
                this.client = client;
                return this;
            }

            public ConfigurationBuilder downloadConfiguration(DownloadConfiguration downloadConfiguration) {
                this.downloadConfiguration$value = downloadConfiguration;
                this.downloadConfiguration$set = true;
                return this;
            }

            public ConfigurationBuilder cacheDirectory(Path cacheDirectory) {
                this.cacheDirectory = cacheDirectory;
                return this;
            }

            public ConfigurationBuilder initialCapacity(Integer initialCapacity) {
                this.initialCapacity$value = initialCapacity;
                this.initialCapacity$set = true;
                return this;
            }

            public ConfigurationBuilder recordStats(boolean recordStats) {
                this.recordStats$value = recordStats;
                this.recordStats$set = true;
                return this;
            }

            public ConfigurationBuilder maximumSize(Integer maximumSize) {
                this.maximumSize$value = maximumSize;
                this.maximumSize$set = true;
                return this;
            }

            public ConfigurationBuilder maximumWeight(Long maximumWeight) {
                this.maximumWeight$value = maximumWeight;
                this.maximumWeight$set = true;
                return this;
            }

            public ConfigurationBuilder concurrencyLevel(Integer concurrencyLevel) {
                this.concurrencyLevel$value = concurrencyLevel;
                this.concurrencyLevel$set = true;
                return this;
            }

            public ConfigurationBuilder expireAfterAccess(Duration expireAfterAccess) {
                this.expireAfterAccess$value = expireAfterAccess;
                this.expireAfterAccess$set = true;
                return this;
            }

            public ConfigurationBuilder expireAfterWrite(Duration expireAfterWrite) {
                this.expireAfterWrite$value = expireAfterWrite;
                this.expireAfterWrite$set = true;
                return this;
            }

            public ConfigurationBuilder consistencyPolicy(ConsistencyPolicy consistencyPolicy) {
                this.consistencyPolicy$value = consistencyPolicy;
                this.consistencyPolicy$set = true;
                return this;
            }

            public ConfigurationBuilder downloadExecutor(ExecutorService downloadExecutor) {
                this.downloadExecutor$value = downloadExecutor;
                this.downloadExecutor$set = true;
                return this;
            }

            public ConfigurationBuilder deletionExecutor(ExecutorService deletionExecutor) {
                this.deletionExecutor$value = deletionExecutor;
                this.deletionExecutor$set = true;
                return this;
            }

            public ConfigurationBuilder uncacheablePredicate(UncacheablePredicate uncacheablePredicate) {
                this.uncacheablePredicate$value = uncacheablePredicate;
                this.uncacheablePredicate$set = true;
                return this;
            }

            public ConfigurationBuilder rowLockProvider(RowLockProvider rowLockProvider) {
                this.rowLockProvider$value = rowLockProvider;
                this.rowLockProvider$set = true;
                return this;
            }

            public ConfigurationBuilder cacheGarbageCollection(Runnable cacheGarbageCollection) {
                this.cacheGarbageCollection$value = cacheGarbageCollection;
                this.cacheGarbageCollection$set = true;
                return this;
            }

            public Configuration build() {
                DownloadConfiguration downloadConfiguration$value = this.downloadConfiguration$value;
                if (!this.downloadConfiguration$set) {
                    downloadConfiguration$value = Configuration.$default$downloadConfiguration();
                }
                Integer initialCapacity$value = this.initialCapacity$value;
                if (!this.initialCapacity$set) {
                    initialCapacity$value = Configuration.$default$initialCapacity();
                }
                boolean recordStats$value = this.recordStats$value;
                if (!this.recordStats$set) {
                    recordStats$value = Configuration.$default$recordStats();
                }
                Integer maximumSize$value = this.maximumSize$value;
                if (!this.maximumSize$set) {
                    maximumSize$value = Configuration.$default$maximumSize();
                }
                Long maximumWeight$value = this.maximumWeight$value;
                if (!this.maximumWeight$set) {
                    maximumWeight$value = Configuration.$default$maximumWeight();
                }
                Integer concurrencyLevel$value = this.concurrencyLevel$value;
                if (!this.concurrencyLevel$set) {
                    concurrencyLevel$value = Configuration.$default$concurrencyLevel();
                }
                Duration expireAfterAccess$value = this.expireAfterAccess$value;
                if (!this.expireAfterAccess$set) {
                    expireAfterAccess$value = Configuration.$default$expireAfterAccess();
                }
                Duration expireAfterWrite$value = this.expireAfterWrite$value;
                if (!this.expireAfterWrite$set) {
                    expireAfterWrite$value = Configuration.$default$expireAfterWrite();
                }
                ConsistencyPolicy consistencyPolicy$value = this.consistencyPolicy$value;
                if (!this.consistencyPolicy$set) {
                    consistencyPolicy$value = Configuration.$default$consistencyPolicy();
                }
                ExecutorService downloadExecutor$value = this.downloadExecutor$value;
                if (!this.downloadExecutor$set) {
                    downloadExecutor$value = Configuration.$default$downloadExecutor();
                }
                ExecutorService deletionExecutor$value = this.deletionExecutor$value;
                if (!this.deletionExecutor$set) {
                    deletionExecutor$value = Configuration.$default$deletionExecutor();
                }
                UncacheablePredicate uncacheablePredicate$value = this.uncacheablePredicate$value;
                if (!this.uncacheablePredicate$set) {
                    uncacheablePredicate$value = Configuration.$default$uncacheablePredicate();
                }
                RowLockProvider rowLockProvider$value = this.rowLockProvider$value;
                if (!this.rowLockProvider$set) {
                    rowLockProvider$value = Configuration.$default$rowLockProvider();
                }
                Runnable cacheGarbageCollection$value = this.cacheGarbageCollection$value;
                if (!this.cacheGarbageCollection$set) {
                    cacheGarbageCollection$value = Configuration.$default$cacheGarbageCollection();
                }
                return new Configuration(this.client, downloadConfiguration$value, this.cacheDirectory, initialCapacity$value, recordStats$value, maximumSize$value, maximumWeight$value, concurrencyLevel$value, expireAfterAccess$value, expireAfterWrite$value, consistencyPolicy$value, downloadExecutor$value, deletionExecutor$value, uncacheablePredicate$value, rowLockProvider$value, cacheGarbageCollection$value);
            }

            public String toString() {
                return "CachingObjectStorage.Configuration.ConfigurationBuilder(client=" + this.client + ", downloadConfiguration$value=" + this.downloadConfiguration$value + ", cacheDirectory=" + this.cacheDirectory + ", initialCapacity$value=" + this.initialCapacity$value + ", recordStats$value=" + this.recordStats$value + ", maximumSize$value=" + this.maximumSize$value + ", maximumWeight$value=" + this.maximumWeight$value + ", concurrencyLevel$value=" + this.concurrencyLevel$value + ", expireAfterAccess$value=" + this.expireAfterAccess$value + ", expireAfterWrite$value=" + this.expireAfterWrite$value + ", consistencyPolicy$value=" + this.consistencyPolicy$value + ", downloadExecutor$value=" + this.downloadExecutor$value + ", deletionExecutor$value=" + this.deletionExecutor$value + ", uncacheablePredicate$value=" + this.uncacheablePredicate$value + ", rowLockProvider$value=" + this.rowLockProvider$value + ", cacheGarbageCollection$value=" + this.cacheGarbageCollection$value + ")";
            }
        }
    }
}

