/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.hdfs;

import com.oracle.bmc.hdfs.caching.StrongConsistencyPolicy;
import java.beans.ConstructorProperties;
import java.util.concurrent.TimeUnit;

public enum BmcProperties {
    BLOCK_SIZE_IN_MB("fs.oci.blocksize.mb", 32L),
    IN_MEMORY_WRITE_BUFFER("fs.oci.io.write.inmemory", false),
    IN_MEMORY_READ_BUFFER("fs.oci.io.read.inmemory", false),
    OBJECT_STORE_CLIENT_CLASS("fs.oci.client.custom.client", null),
    OBJECT_STORE_AUTHENTICATOR_CLASS("fs.oci.client.custom.authenticator", null),
    HOST_NAME("fs.oci.client.hostname", null),
    TENANT_ID("fs.oci.client.auth.tenantId", null),
    USER_ID("fs.oci.client.auth.userId", null),
    FINGERPRINT("fs.oci.client.auth.fingerprint", null),
    PEM_FILE_PATH("fs.oci.client.auth.pemfilepath", null),
    PASS_PHRASE("fs.oci.client.auth.passphrase", null),
    REGION_CODE_OR_ID("fs.oci.client.regionCodeOrId", null),
    CONNECTION_TIMEOUT_MILLIS("fs.oci.client.http.connectiontimeout", null),
    READ_TIMEOUT_MILLIS("fs.oci.client.http.readtimeout", null),
    MULTIPART_ALLOWED("fs.oci.client.multipart.allowed", true),
    MULTIPART_NUM_UPLOAD_THREADS("fs.oci.client.multipart.numthreads", null),
    MULTIPART_MIN_SIZE_OF_OBJECT_IN_MB("fs.oci.client.multipart.minobjectsize.mb", null),
    MULTIPART_MIN_PART_SIZE_IN_MB("fs.oci.client.multipart.minpartsize.mb", null),
    MULTIPART_PART_SIZE_IN_MB("fs.oci.client.multipart.partsize.mb", null),
    HTTP_PROXY_URI("fs.oci.client.proxy.uri", null),
    HTTP_PROXY_USERNAME("fs.oci.client.proxy.username", null),
    HTTP_PROXY_PASSWORD("fs.oci.client.proxy.password", null),
    RETRY_TIMEOUT_IN_SECONDS("fs.oci.client.retry.timeout.seconds", 30L),
    RETRY_TIMEOUT_RESET_THRESHOLD_IN_SECONDS("fs.oci.client.retry.reset.threshold.seconds", 0L),
    OBJECT_METADATA_CACHING_ENABLED("fs.oci.caching.object.metadata.enabled", false),
    OBJECT_METADATA_CACHING_SPEC("fs.oci.caching.object.metadata.spec", "maximumSize=1024,expireAfterWrite=5m"),
    JERSEY_CLIENT_LOGGING_ENABLED("fs.oci.client.jersey.logging.enabled", false),
    JERSEY_CLIENT_LOGGING_LEVEL("fs.oci.client.jersey.logging.level", "WARNING"),
    JERSEY_CLIENT_LOGGING_VERBOSITY("fs.oci.client.jersey.logging.verbosity", "PAYLOAD_ANY"),
    READ_AHEAD("fs.oci.io.read.ahead", false),
    READ_AHEAD_BLOCK_SIZE("fs.oci.io.read.ahead.blocksize", 0x600000),
    OBJECT_PARQUET_CACHING_ENABLED("fs.oci.caching.object.parquet.enabled", false),
    OBJECT_PARQUET_CACHING_SPEC("fs.oci.caching.object.parquet.spec", "maximumSize=10240,expireAfterWrite=15m"),
    APACHE_CONNECTION_CLOSING_STRATEGY("fs.oci.client.apache.connection.closing.strategy", "IMMEDIATE"),
    OBJECT_PAYLOAD_CACHING_ENABLED("fs.oci.caching.object.payload.enabled", false),
    OBJECT_PAYLOAD_CACHING_MAXIMUM_WEIGHT_IN_BYTES("fs.oci.caching.object.payload.maxweight.bytes", 0x100000000L),
    OBJECT_PAYLOAD_CACHING_MAXIMUM_SIZE("fs.oci.caching.object.payload.maxsize.count", null),
    OBJECT_PAYLOAD_CACHING_INITIAL_CAPACITY("fs.oci.caching.object.payload.initialcapacity.count", 1024),
    OBJECT_PAYLOAD_CACHING_RECORD_STATS_ENABLED("fs.oci.caching.object.payload.recordstats.enabled", false),
    OBJECT_PAYLOAD_CACHING_RECORD_STATS_TIME_INTERVAL_IN_SECONDS("fs.oci.caching.object.payload.recordstats.timeinterval.seconds", 60L),
    OBJECT_PAYLOAD_CACHING_EXPIRE_AFTER_ACCESS_SECONDS("fs.oci.caching.object.payload.expireafteraccess.seconds", null),
    OBJECT_PAYLOAD_CACHING_EXPIRE_AFTER_WRITE_SECONDS("fs.oci.caching.object.payload.expireafterwrite.seconds", (int)TimeUnit.MINUTES.toSeconds(10L)),
    OBJECT_PAYLOAD_CACHING_CONSISTENCY_POLICY_CLASS("fs.oci.caching.object.payload.consistencypolicy.class", StrongConsistencyPolicy.class.getName()),
    OBJECT_PAYLOAD_CACHING_DIRECTORY("fs.oci.caching.object.payload.directory", null),
    JERSEY_CLIENT_DEFAULT_CONNECTOR_ENABLED("fs.oci.client.jersey.default.connector.enabled", false),
    APACHE_MAX_CONNECTION_POOL_SIZE("fs.oci.client.apache.max.connection.pool.size", 50),
    RENAME_DIRECTORY_NUM_THREADS("fs.oci.rename.operation.numthreads", 1),
    MULTIPART_IN_MEMORY_WRITE_BUFFER_ENABLED("fs.oci.io.write.multipart.inmemory", false),
    MULTIPART_IN_MEMORY_WRITE_TASK_TIMEOUT_SECONDS("fs.oci.io.write.multipart.inmemory.tasktimeout.seconds", 900),
    MULTIPART_ALLOW_OVERWRITE("fs.oci.io.write.multipart.overwrite", false),
    OBJECT_AUTO_CLOSE_INPUT_STREAM("fs.oci.object.autoclose.inputstream", true),
    READ_STREAM_CLASS("fs.oci.io.read.custom.stream", null),
    WRITE_STREAM_CLASS("fs.oci.io.write.custom.stream", null),
    FILESYSTEM_CACHING_ENABLED("fs.oci.caching.filesystem.enabled", false),
    FILESYSTEM_CACHING_MAXIMUM_SIZE("fs.oci.caching.filesystem.maxsize.count", 1024),
    FILESYSTEM_CACHING_INITIAL_CAPACITY("fs.oci.caching.filesystem.initialcapacity.count", 1024),
    FILESYSTEM_CACHING_EXPIRE_AFTER_ACCESS_SECONDS("fs.oci.caching.filesystem.expireafteraccess.seconds", null),
    FILESYSTEM_CACHING_EXPIRE_AFTER_WRITE_SECONDS("fs.oci.caching.filesystem.expireafterwrite.seconds", (int)TimeUnit.MINUTES.toSeconds(30L));

    private final String propertyName;
    private final Object defaultValue;

    @ConstructorProperties(value={"propertyName", "defaultValue"})
    private BmcProperties(String propertyName, Object defaultValue) {
        this.propertyName = propertyName;
        this.defaultValue = defaultValue;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }
}

