/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import java.util.Iterator;
import java.util.Random;
import java.util.TreeSet;
import org.apache.omid.tso.LongCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestLongCache {
    private static final Logger LOG = LoggerFactory.getLogger(TestLongCache.class);
    private static final long TEST_VALUE = 1000L;
    private Random random = new Random(System.currentTimeMillis());

    @Test(timeOut=10000L)
    public void testAddAndGetElems() {
        int CACHE_SIZE = 10000000;
        int CACHE_ASSOCIATIVITY = 32;
        LongCache cache = new LongCache(10000000, 32);
        for (int i = 0; i < 1000; ++i) {
            long position = this.random.nextLong();
            Assert.assertEquals((long)cache.get(position), (long)0L);
        }
        TreeSet<Long> testedKeys = new TreeSet<Long>();
        for (int i = 0; i < 1000; ++i) {
            long position = this.random.nextLong();
            cache.set(position, 1000L);
            testedKeys.add(position);
        }
        Iterator iterator = testedKeys.iterator();
        while (iterator.hasNext()) {
            long key = (Long)iterator.next();
            Assert.assertEquals((long)cache.get(key), (long)1000L);
        }
    }

    @Test(timeOut=10000L)
    public void testEntriesAge() {
        int i;
        int entries = 1000;
        LongCache cache = new LongCache(1000, 16);
        int removals = 0;
        long totalAge = 0L;
        double tempStdDev = 0.0;
        double tempAvg = 0.0;
        int largestDeletedTimestamp = 0;
        for (i = 0; i < 10000; ++i) {
            long removed = cache.set(this.random.nextLong(), (long)i);
            if (removed <= (long)largestDeletedTimestamp) continue;
            largestDeletedTimestamp = (int)removed;
        }
        long time = System.nanoTime();
        while (i < 100000) {
            long removed = cache.set(this.random.nextLong(), (long)i);
            if (removed > (long)largestDeletedTimestamp) {
                largestDeletedTimestamp = (int)removed;
            }
            int gap = i - largestDeletedTimestamp;
            totalAge += (long)gap;
            double oldAvg = tempAvg;
            tempAvg += ((double)gap - tempAvg) / (double)(++removals);
            tempStdDev += ((double)gap - oldAvg) * ((double)gap - tempAvg);
            ++i;
        }
        long elapsed = System.nanoTime() - time;
        LOG.info("Elapsed (ms): " + (double)elapsed / 1000.0);
        double avgGap = (double)totalAge / (double)removals;
        LOG.info("Avg gap: " + tempAvg);
        LOG.info("Std dev gap: " + Math.sqrt(tempStdDev / 1000.0));
        Assert.assertTrue((avgGap > 600.0 ? 1 : 0) != 0, (String)"avgGap should be greater than entries * 0.6");
    }
}

