/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import org.apache.omid.proto.TSOProto;
import org.apache.omid.tso.TSOChannelHandler;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgrammableTSOServer
extends SimpleChannelHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ProgrammableTSOServer.class);
    private ChannelFactory factory;
    private ChannelGroup channelGroup;
    private Queue<Response> responseQueue = new LinkedList<Response>();

    @Inject
    public ProgrammableTSOServer(int port) {
        this.factory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("boss-%d").build()), (Executor)Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("worker-%d").build()), (Runtime.getRuntime().availableProcessors() * 2 + 1) * 2);
        this.channelGroup = new DefaultChannelGroup(ProgrammableTSOServer.class.getName());
        ServerBootstrap bootstrap = new ServerBootstrap(this.factory);
        bootstrap.setPipelineFactory((ChannelPipelineFactory)new TSOChannelHandler.TSOPipelineFactory((ChannelHandler)this));
        Channel channel = bootstrap.bind((SocketAddress)new InetSocketAddress(port));
        this.channelGroup.add((Object)channel);
        LOG.info("********** Dumb TSO Server running on port {} **********", (Object)port);
    }

    public void queueResponse(Response r) {
        this.responseQueue.add(r);
    }

    public void cleanResponses() {
        this.responseQueue.clear();
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.channelGroup.add((Object)ctx.getChannel());
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.channelGroup.remove((Object)ctx.getChannel());
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        block10: {
            Object msg;
            block8: {
                TSOProto.Request request;
                block11: {
                    Response resp;
                    Channel channel;
                    block9: {
                        msg = e.getMessage();
                        if (!(msg instanceof TSOProto.Request)) break block8;
                        request = (TSOProto.Request)msg;
                        channel = ctx.getChannel();
                        if (request.hasHandshakeRequest()) {
                            this.checkHandshake(ctx, request.getHandshakeRequest());
                            return;
                        }
                        if (!this.handshakeCompleted(ctx)) {
                            LOG.info("handshake not completed");
                            channel.close();
                        }
                        resp = this.responseQueue.poll();
                        if (!request.hasTimestampRequest()) break block9;
                        if (resp == null || resp.type != Response.ResponseType.TIMESTAMP) {
                            throw new IllegalStateException("Expecting TS response to send but got " + resp);
                        }
                        TimestampResponse tsResp = (TimestampResponse)resp;
                        this.sendTimestampResponse(tsResp.startTS, channel);
                        break block10;
                    }
                    if (!request.hasCommitRequest()) break block11;
                    if (resp == null) {
                        throw new IllegalStateException("Expecting COMMIT response to send but got null");
                    }
                    switch (resp.type) {
                        case COMMIT: {
                            CommitResponse commitResp = (CommitResponse)resp;
                            this.sendCommitResponse(commitResp.startTS, commitResp.commitTS, channel);
                            break block10;
                        }
                        case ABORT: {
                            AbortResponse abortResp = (AbortResponse)resp;
                            this.sendAbortResponse(abortResp.startTS, channel);
                            break block10;
                        }
                        default: {
                            throw new IllegalStateException("Expecting COMMIT response to send but got " + (Object)((Object)resp.type));
                        }
                    }
                }
                LOG.error("Invalid request {}", (Object)request);
                ctx.getChannel().close();
                break block10;
            }
            LOG.error("Unknown message type", msg);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        if (e.getCause() instanceof ClosedChannelException) {
            return;
        }
        LOG.warn("TSOHandler: Unexpected exception from downstream.", e.getCause());
        Channels.close((Channel)e.getChannel());
    }

    private void checkHandshake(ChannelHandlerContext ctx, TSOProto.HandshakeRequest request) {
        TSOProto.HandshakeResponse.Builder response = TSOProto.HandshakeResponse.newBuilder();
        if (request.hasClientCapabilities()) {
            response.setClientCompatible(true).setServerCapabilities(TSOProto.Capabilities.newBuilder().build());
            TSOChannelContext tsoCtx = new TSOChannelContext();
            tsoCtx.setHandshakeComplete();
            ctx.setAttachment((Object)tsoCtx);
        } else {
            response.setClientCompatible(false);
        }
        ctx.getChannel().write((Object)TSOProto.Response.newBuilder().setHandshakeResponse(response.build()).build());
    }

    private boolean handshakeCompleted(ChannelHandlerContext ctx) {
        Object o = ctx.getAttachment();
        if (o instanceof TSOChannelContext) {
            TSOChannelContext tsoCtx = (TSOChannelContext)o;
            return tsoCtx.getHandshakeComplete();
        }
        return false;
    }

    private void sendTimestampResponse(long startTimestamp, Channel c) {
        TSOProto.Response.Builder builder = TSOProto.Response.newBuilder();
        TSOProto.TimestampResponse.Builder respBuilder = TSOProto.TimestampResponse.newBuilder();
        respBuilder.setStartTimestamp(startTimestamp);
        builder.setTimestampResponse(respBuilder.build());
        c.write((Object)builder.build());
    }

    private void sendCommitResponse(long startTimestamp, long commitTimestamp, Channel c) {
        TSOProto.Response.Builder builder = TSOProto.Response.newBuilder();
        TSOProto.CommitResponse.Builder commitBuilder = TSOProto.CommitResponse.newBuilder();
        commitBuilder.setAborted(false).setStartTimestamp(startTimestamp).setCommitTimestamp(commitTimestamp);
        builder.setCommitResponse(commitBuilder.build());
        c.write((Object)builder.build());
    }

    private void sendAbortResponse(long startTimestamp, Channel c) {
        TSOProto.Response.Builder builder = TSOProto.Response.newBuilder();
        TSOProto.CommitResponse.Builder commitBuilder = TSOProto.CommitResponse.newBuilder();
        commitBuilder.setAborted(true).setStartTimestamp(startTimestamp);
        builder.setCommitResponse(commitBuilder.build());
        c.write((Object)builder.build());
    }

    static abstract class Response {
        final ResponseType type;

        public Response(ResponseType type) {
            this.type = type;
        }

        static enum ResponseType {
            TIMESTAMP,
            COMMIT,
            ABORT;

        }
    }

    public static class AbortResponse
    extends Response {
        final long startTS;

        public AbortResponse(long startTS) {
            super(Response.ResponseType.ABORT);
            this.startTS = startTS;
        }
    }

    public static class CommitResponse
    extends Response {
        final long startTS;
        final long commitTS;

        public CommitResponse(long startTS, long commitTS) {
            super(Response.ResponseType.COMMIT);
            this.startTS = startTS;
            this.commitTS = commitTS;
        }
    }

    public static class TimestampResponse
    extends Response {
        final long startTS;

        public TimestampResponse(long startTS) {
            super(Response.ResponseType.TIMESTAMP);
            this.startTS = startTS;
        }
    }

    private static class TSOChannelContext {
        boolean handshakeComplete = false;

        TSOChannelContext() {
        }

        boolean getHandshakeComplete() {
            return this.handshakeComplete;
        }

        void setHandshakeComplete() {
            this.handshakeComplete = true;
        }
    }
}

