/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.delta.format;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRule;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.metastore.MetadataProviderManager;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.physical.base.AbstractWriter;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.planner.PlannerPhase;
import org.apache.drill.exec.planner.common.DrillStatsTable;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.record.metadata.schema.SchemaProvider;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.store.PluginRulesProvider;
import org.apache.drill.exec.store.PluginRulesProviderImpl;
import org.apache.drill.exec.store.StoragePluginRulesSupplier;
import org.apache.drill.exec.store.delta.DeltaGroupScan;
import org.apache.drill.exec.store.delta.format.DeltaFormatMatcher;
import org.apache.drill.exec.store.delta.format.DeltaFormatPluginConfig;
import org.apache.drill.exec.store.delta.plan.DeltaPluginImplementor;
import org.apache.drill.exec.store.dfs.FileSelection;
import org.apache.drill.exec.store.dfs.FileSystemConfig;
import org.apache.drill.exec.store.dfs.FormatMatcher;
import org.apache.drill.exec.store.dfs.FormatPlugin;
import org.apache.drill.exec.store.parquet.ParquetReaderConfig;
import org.apache.drill.exec.store.plan.rel.PluginRel;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class DeltaFormatPlugin
implements FormatPlugin {
    private static final String DELTA_CONVENTION_PREFIX = "DELTA.";
    private static final AtomicInteger NEXT_ID = new AtomicInteger(0);
    private final FileSystemConfig storageConfig;
    private final DeltaFormatPluginConfig config;
    private final Configuration fsConf;
    private final DrillbitContext context;
    private final String name;
    private final DeltaFormatMatcher matcher;
    private final StoragePluginRulesSupplier storagePluginRulesSupplier;

    public DeltaFormatPlugin(String name, DrillbitContext context, Configuration fsConf, FileSystemConfig storageConfig, DeltaFormatPluginConfig config) {
        this.storageConfig = storageConfig;
        this.config = config;
        this.fsConf = fsConf;
        this.context = context;
        this.name = name;
        this.matcher = new DeltaFormatMatcher(this);
        this.storagePluginRulesSupplier = DeltaFormatPlugin.storagePluginRulesSupplier(name + NEXT_ID.getAndIncrement());
    }

    private static StoragePluginRulesSupplier storagePluginRulesSupplier(String name) {
        Convention.Impl convention = new Convention.Impl(DELTA_CONVENTION_PREFIX + name, PluginRel.class);
        return StoragePluginRulesSupplier.builder().rulesProvider((PluginRulesProvider)new PluginRulesProviderImpl((Convention)convention, DeltaPluginImplementor::new)).supportsFilterPushdown(true).supportsProjectPushdown(true).supportsLimitPushdown(true).convention((Convention)convention).build();
    }

    public boolean supportsRead() {
        return true;
    }

    public boolean supportsWrite() {
        return false;
    }

    public boolean supportsAutoPartitioning() {
        return false;
    }

    public FormatMatcher getMatcher() {
        return this.matcher;
    }

    public AbstractWriter getWriter(PhysicalOperator child, String location, List<String> partitionColumns) {
        throw new UnsupportedOperationException();
    }

    public Set<? extends RelOptRule> getOptimizerRules(PlannerPhase phase) {
        switch (phase) {
            case PHYSICAL: 
            case LOGICAL: {
                return this.storagePluginRulesSupplier.getOptimizerRules();
            }
        }
        return Collections.emptySet();
    }

    public AbstractGroupScan getGroupScan(String userName, FileSelection selection, List<SchemaPath> columns) throws IOException {
        return this.getGroupScan(userName, selection, columns, (OptionManager)null);
    }

    public AbstractGroupScan getGroupScan(String userName, FileSelection selection, List<SchemaPath> columns, OptionManager options) throws IOException {
        return this.getGroupScan(userName, selection, columns, options, null);
    }

    public AbstractGroupScan getGroupScan(String userName, FileSelection selection, List<SchemaPath> columns, OptionManager options, MetadataProviderManager metadataProviderManager) throws IOException {
        ParquetReaderConfig readerConfig = ParquetReaderConfig.builder().withConf(this.fsConf).withOptions(options).build();
        return DeltaGroupScan.builder().userName(userName).formatPlugin(this).readerConfig(readerConfig).path(selection.selectionRoot.toUri().getPath()).columns(columns).limit(-1).build();
    }

    public AbstractGroupScan getGroupScan(String userName, FileSelection selection, List<SchemaPath> columns, MetadataProviderManager metadataProviderManager) throws IOException {
        SchemaProvider schemaProvider = metadataProviderManager.getSchemaProvider();
        TupleMetadata schema = schemaProvider != null ? schemaProvider.read().getSchema() : null;
        return DeltaGroupScan.builder().userName(userName).formatPlugin(this).readerConfig(ParquetReaderConfig.builder().withConf(this.fsConf).build()).schema(schema).path(selection.selectionRoot.toUri().getPath()).columns(columns).limit(-1).build();
    }

    public boolean supportsStatistics() {
        return false;
    }

    public DrillStatsTable.TableStatistics readStatistics(FileSystem fs, Path statsTablePath) {
        throw new UnsupportedOperationException("unimplemented");
    }

    public void writeStatistics(DrillStatsTable.TableStatistics statistics, FileSystem fs, Path statsTablePath) {
        throw new UnsupportedOperationException("unimplemented");
    }

    public DeltaFormatPluginConfig getConfig() {
        return this.config;
    }

    public FileSystemConfig getStorageConfig() {
        return this.storageConfig;
    }

    public Configuration getFsConf() {
        return this.fsConf;
    }

    public DrillbitContext getContext() {
        return this.context;
    }

    public String getName() {
        return this.name;
    }

    public Convention getConvention() {
        return this.storagePluginRulesSupplier.convention();
    }
}

