/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.delta;

import java.io.IOException;
import java.util.LinkedHashMap;
import org.apache.drill.exec.metastore.MetadataProviderManager;
import org.apache.drill.exec.store.delta.format.DeltaFormatPlugin;
import org.apache.drill.exec.store.dfs.ReadEntryWithPath;
import org.apache.drill.exec.store.parquet.BaseParquetMetadataProvider;
import org.apache.drill.exec.store.parquet.ParquetReaderConfig;
import org.apache.drill.exec.store.parquet.metadata.Metadata;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class DeltaParquetTableMetadataProvider
extends BaseParquetMetadataProvider {
    private final DeltaFormatPlugin deltaFormatPlugin;

    private DeltaParquetTableMetadataProvider(Builder builder) throws IOException {
        super((BaseParquetMetadataProvider.Builder)builder);
        this.deltaFormatPlugin = builder.formatPlugin;
        this.init((BaseParquetMetadataProvider)builder.metadataProviderManager().getTableMetadataProvider());
    }

    protected void initInternal() throws IOException {
        LinkedHashMap<FileStatus, FileSystem> fileStatusConfMap = new LinkedHashMap<FileStatus, FileSystem>();
        for (ReadEntryWithPath entry : this.entries) {
            Path path = entry.getPath();
            FileSystem fs = path.getFileSystem(this.deltaFormatPlugin.getFsConf());
            fileStatusConfMap.put(fs.getFileStatus(Path.getPathWithoutSchemeAndAuthority((Path)path)), fs);
        }
        this.parquetTableMetadata = Metadata.getParquetTableMetadata(fileStatusConfMap, (ParquetReaderConfig)this.readerConfig);
    }

    public static class Builder
    extends BaseParquetMetadataProvider.Builder<Builder> {
        private DeltaFormatPlugin formatPlugin;

        public Builder(MetadataProviderManager source) {
            super(source);
        }

        protected Builder withFormatPlugin(DeltaFormatPlugin formatPlugin) {
            this.formatPlugin = formatPlugin;
            return this.self();
        }

        protected Builder self() {
            return this;
        }

        public DeltaParquetTableMetadataProvider build() throws IOException {
            return new DeltaParquetTableMetadataProvider(this);
        }
    }
}

