/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.mongo.transform;

import com.mongodb.client.model.Filters;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.drill.metastore.MetastoreColumn;
import org.apache.drill.metastore.expressions.FilterExpression;
import org.apache.drill.metastore.metadata.MetadataType;
import org.apache.drill.metastore.mongo.transform.FilterExpressionVisitor;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.conversions.Bson;

public class FilterTransformer {
    public Bson transform(FilterExpression filter) {
        return filter == null ? new Document() : (Bson)filter.accept(FilterExpressionVisitor.get());
    }

    public Bson transform(Set<MetadataType> metadataTypes) {
        if (metadataTypes.contains(MetadataType.ALL)) {
            return new BsonDocument();
        }
        Set inConditionValues = metadataTypes.stream().map(Enum::name).collect(Collectors.toSet());
        if (inConditionValues.size() == 1) {
            return Filters.eq((String)MetastoreColumn.METADATA_TYPE.columnName(), (Object)((String)inConditionValues.iterator().next()));
        }
        return Filters.in((String)MetastoreColumn.METADATA_TYPE.columnName(), inConditionValues);
    }

    public Bson combine(Bson ... expressions) {
        if (expressions.length == 0) {
            return new BsonDocument();
        }
        if (expressions.length == 1) {
            return expressions[0];
        }
        return Filters.and((Bson[])new Bson[]{expressions[0], expressions[1]});
    }
}

