/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.modularinput;

import com.splunk.modularinput.EventWriter;
import com.splunk.modularinput.InputDefinition;
import com.splunk.modularinput.MalformedDataException;
import com.splunk.modularinput.NonblockingInputStream;
import com.splunk.modularinput.Scheme;
import com.splunk.modularinput.ValidationDefinition;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLStreamException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public abstract class Script {
    public int run(String[] args) {
        try {
            EventWriter eventWriter = new EventWriter();
            return this.run(args, eventWriter, System.in);
        }
        catch (XMLStreamException e) {
            System.err.print(this.stackTraceToLogEntry(e));
            return 1;
        }
    }

    public int run(String[] args, EventWriter eventWriter, InputStream in) {
        try {
            if (args.length == 0) {
                InputDefinition inputDefinition = InputDefinition.parseDefinition(in);
                this.streamEvents(inputDefinition, eventWriter);
                eventWriter.close();
                return 0;
            }
            if (args[0].toLowerCase().equals("--scheme")) {
                Scheme scheme = this.getScheme();
                if (scheme == null) {
                    eventWriter.log("FATAL", "Modular input script returned a null scheme.");
                    return 1;
                }
                eventWriter.writeXmlDocument(scheme.toXml());
                return 0;
            }
            if (args[0].toLowerCase().equals("--validate-arguments")) {
                NonblockingInputStream stream = new NonblockingInputStream(in);
                ValidationDefinition validationDefinition = ValidationDefinition.parseDefinition(stream);
                try {
                    this.validateInput(validationDefinition);
                    return 0;
                }
                catch (Exception e) {
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    documentBuilderFactory.setIgnoringElementContentWhitespace(true);
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    Document document = documentBuilder.newDocument();
                    Element error = document.createElement("error");
                    document.appendChild(error);
                    Element message = document.createElement("message");
                    error.appendChild(message);
                    Text text = document.createTextNode(e.getLocalizedMessage());
                    message.appendChild(text);
                    eventWriter.writeXmlDocument(document);
                    return 1;
                }
            }
            StringBuilder sb = new StringBuilder();
            sb.append("ERROR Invalid arguments to modular input script:");
            for (String arg : args) {
                sb.append(" ");
                sb.append(arg);
            }
            eventWriter.log(EventWriter.ERROR, sb.toString());
            return 1;
        }
        catch (Exception e) {
            eventWriter.log(EventWriter.ERROR, this.stackTraceToLogEntry(e));
            return 1;
        }
    }

    protected String stackTraceToLogEntry(Exception e) {
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement s : e.getStackTrace()) {
            sb.append(s.toString());
            sb.append("\\\\");
        }
        return sb.toString();
    }

    public abstract Scheme getScheme();

    public void validateInput(ValidationDefinition definition) throws Exception {
    }

    public abstract void streamEvents(InputDefinition var1, EventWriter var2) throws MalformedDataException, XMLStreamException, IOException;
}

