/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.modularinput;

import com.splunk.modularinput.Argument;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Scheme {
    private static DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    protected String title;
    protected String description = null;
    protected boolean useExternalValidation = true;
    protected boolean useSingleInstance = false;
    protected StreamingMode streamingMode = StreamingMode.XML;
    protected List<Argument> arguments;

    public Scheme(String title) {
        this.title = title;
        this.arguments = new ArrayList<Argument>();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isUseExternalValidation() {
        return this.useExternalValidation;
    }

    public void setUseExternalValidation(boolean useExternalValidation) {
        this.useExternalValidation = useExternalValidation;
    }

    public boolean isUseSingleInstance() {
        return this.useSingleInstance;
    }

    public void setUseSingleInstance(boolean useSingleInstance) {
        this.useSingleInstance = useSingleInstance;
    }

    public StreamingMode getStreamingMode() {
        return this.streamingMode;
    }

    public void setStreamingMode(StreamingMode streamingMode) {
        this.streamingMode = streamingMode;
    }

    public List<Argument> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<Argument> arguments) {
        this.arguments = new ArrayList<Argument>(arguments);
    }

    public void addArgument(Argument argument) {
        this.arguments.add(argument);
    }

    Document toXml() throws ParserConfigurationException {
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document doc = documentBuilder.newDocument();
        Element root = doc.createElement("scheme");
        doc.appendChild(root);
        Element title = doc.createElement("title");
        title.appendChild(doc.createTextNode(this.title));
        root.appendChild(title);
        if (this.description != null) {
            Element description = doc.createElement("description");
            description.appendChild(doc.createTextNode(this.description));
            root.appendChild(description);
        }
        Element useExternalValidation = doc.createElement("use_external_validation");
        useExternalValidation.appendChild(doc.createTextNode(Boolean.toString(this.useExternalValidation)));
        root.appendChild(useExternalValidation);
        Element useSingleInstance = doc.createElement("use_single_instance");
        useSingleInstance.appendChild(doc.createTextNode(Boolean.toString(this.useSingleInstance)));
        root.appendChild(useSingleInstance);
        Element streamingMode = doc.createElement("streaming_mode");
        streamingMode.appendChild(doc.createTextNode(this.streamingMode == StreamingMode.SIMPLE ? "simple" : "xml"));
        root.appendChild(streamingMode);
        Element endpoint = doc.createElement("endpoint");
        root.appendChild(endpoint);
        Element args = doc.createElement("args");
        endpoint.appendChild(args);
        for (Argument arg : this.arguments) {
            arg.addToDocument(doc, args);
        }
        return doc;
    }

    public static enum StreamingMode {
        SIMPLE,
        XML;

    }
}

