/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.modularinput;

import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Argument {
    private static DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    protected String name;
    protected String description = null;
    protected String validation = null;
    protected DataType dataType = DataType.STRING;
    protected boolean requiredOnEdit = false;
    protected boolean requiredOnCreate = false;

    public Argument(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getValidation() {
        return this.validation;
    }

    public void setValidation(String validation) {
        this.validation = validation;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public boolean isRequiredOnEdit() {
        return this.requiredOnEdit;
    }

    public void setRequiredOnEdit(boolean requiredOnEdit) {
        this.requiredOnEdit = requiredOnEdit;
    }

    public boolean isRequiredOnCreate() {
        return this.requiredOnCreate;
    }

    public void setRequiredOnCreate(boolean requiredOnCreate) {
        this.requiredOnCreate = requiredOnCreate;
    }

    public void addToDocument(Document doc, Node parent) {
        Element arg = doc.createElement("arg");
        arg.setAttribute("name", this.name);
        if (this.description != null) {
            Element description = doc.createElement("description");
            description.appendChild(doc.createTextNode(this.description));
            arg.appendChild(description);
        }
        if (this.validation != null) {
            Element validation = doc.createElement("validation");
            validation.appendChild(doc.createTextNode(this.validation));
            arg.appendChild(validation);
        }
        Element dataType = doc.createElement("data_type");
        dataType.appendChild(doc.createTextNode(this.dataType.toString().toLowerCase()));
        arg.appendChild(dataType);
        Element requiredOnEdit = doc.createElement("required_on_edit");
        requiredOnEdit.appendChild(doc.createTextNode(Boolean.toString(this.requiredOnEdit)));
        arg.appendChild(requiredOnEdit);
        Element requiredOnCreate = doc.createElement("required_on_create");
        requiredOnCreate.appendChild(doc.createTextNode(Boolean.toString(this.requiredOnCreate)));
        arg.appendChild(requiredOnCreate);
        parent.appendChild(arg);
    }

    public static enum DataType {
        BOOLEAN,
        NUMBER,
        STRING;

    }
}

