/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.splunk.DataModelObject;
import com.splunk.FieldType;
import com.splunk.PivotFilter;
import com.splunk.StringComparison;

public class StringPivotFilter
extends PivotFilter {
    private final StringComparison comparison;
    private final String comparisonValue;

    StringPivotFilter(DataModelObject dataModelObject, String fieldName, StringComparison comparison, String comparisonValue) {
        super(dataModelObject, fieldName);
        if (dataModelObject.getField(fieldName).getType() != FieldType.STRING) {
            throw new IllegalArgumentException("Field " + fieldName + " on the data model object was of type " + dataModelObject.getField(fieldName).getType().toString() + ", expected string.");
        }
        this.comparison = comparison;
        this.comparisonValue = comparisonValue;
    }

    @Override
    JsonElement toJson() {
        JsonObject root = new JsonObject();
        this.addCommonFields(root);
        JsonObject filterRule = new JsonObject();
        filterRule.add("comparator", (JsonElement)new JsonPrimitive(this.comparison.toString()));
        filterRule.add("compareTo", (JsonElement)new JsonPrimitive(this.comparisonValue));
        root.add("rule", (JsonElement)filterRule);
        return root;
    }
}

