/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.splunk.Event;
import com.splunk.ExportResultsStream;
import com.splunk.SearchResults;
import com.splunk.StreamIterableBase;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

public abstract class ResultsReader
extends StreamIterableBase<Event>
implements SearchResults {
    protected final InputStream inputStream;
    boolean isPreview;
    boolean isExportStream;
    private boolean isInMultiReader;

    ResultsReader(InputStream inputStream, boolean isInMultiReader) throws IOException {
        this.inputStream = inputStream;
        this.isExportStream = inputStream instanceof ExportResultsStream;
        this.isInMultiReader = isInMultiReader;
    }

    public void close() throws IOException {
        this.inputStream.close();
    }

    public final Event getNextEvent() throws IOException {
        return this.getNextElement();
    }

    @Override
    public final Iterator<Event> iterator() {
        return super.iterator();
    }

    @Override
    final Event getNextElement() throws IOException {
        Event event;
        while ((event = this.getNextEventInCurrentSet()) == null && !this.isPreview && this.advanceStreamToNextSet()) {
            assert (!this.isPreview) : "Preview result set should never be after a final set.";
        }
        return event;
    }

    abstract Event getNextEventInCurrentSet() throws IOException;

    final boolean resetIteratorToNextSet() throws IOException {
        boolean hasMoreResults = this.advanceStreamToNextSet();
        this.resetIteration(hasMoreResults);
        return hasMoreResults;
    }

    boolean advanceStreamToNextSet() throws IOException {
        return false;
    }

    final void finishInitialization() throws IOException {
        if (this.isInMultiReader) {
            return;
        }
        do {
            if (this.advanceStreamToNextSet()) continue;
            this.resetIteration(false);
            break;
        } while (this.isExportStream && this.isPreview);
    }
}

