/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.splunk.DataModelObject;
import com.splunk.PivotColumnSplit;

public class RangePivotColumnSplit
extends PivotColumnSplit {
    private final Integer start;
    private final Integer end;
    private final Integer step;
    private final Integer limit;

    RangePivotColumnSplit(DataModelObject dataModelObject, String field, Integer start, Integer end, Integer step, Integer limit) {
        super(dataModelObject, field);
        this.start = start;
        this.end = end;
        this.step = step;
        this.limit = limit;
    }

    public Integer getStart() {
        return this.start;
    }

    public Integer getEnd() {
        return this.end;
    }

    public Integer getStep() {
        return this.step;
    }

    @Override
    JsonObject toJson() {
        JsonObject root = new JsonObject();
        this.addCommonFields(root);
        JsonObject ranges = new JsonObject();
        if (this.start != null) {
            ranges.add("start", (JsonElement)new JsonPrimitive(this.start.toString()));
        }
        if (this.end != null) {
            ranges.add("end", (JsonElement)new JsonPrimitive(this.end.toString()));
        }
        if (this.step != null) {
            ranges.add("size", (JsonElement)new JsonPrimitive(this.step.toString()));
        }
        if (this.limit != null) {
            ranges.add("maxNumberOf", (JsonElement)new JsonPrimitive(this.limit.toString()));
        }
        root.add("ranges", (JsonElement)ranges);
        root.add("display", (JsonElement)new JsonPrimitive("ranges"));
        return root;
    }
}

