/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.splunk.Entity;
import com.splunk.Service;
import com.splunk.Util;
import java.util.HashMap;
import java.util.Map;

public class LicensePool
extends Entity {
    LicensePool(Service service, String path) {
        super(service, path);
    }

    public String getDescription() {
        return this.getString("description", null);
    }

    public String getQuota() {
        return this.getString("quota", "0");
    }

    public String[] getSlaves() {
        if (this.toUpdate.containsKey("slaves")) {
            String value = (String)this.toUpdate.get("slaves");
            return value.split(",");
        }
        return this.getStringArray("slaves", null);
    }

    public Map<String, Long> getSlavesUsageBytes() {
        HashMap values = (HashMap)this.get("slaves_usage_bytes");
        if (values == null) {
            values = new HashMap();
        }
        HashMap<String, Long> usageBytes = new HashMap<String, Long>();
        for (String key : values.keySet()) {
            String value = (String)values.get(key);
            usageBytes.put(key, Long.parseLong(value));
        }
        return usageBytes;
    }

    public String getStackId() {
        return this.getString("stack_id", null);
    }

    public long getUsedBytes() {
        return this.getLong("used_bytes", 0);
    }

    public void setAppendSlaves(boolean appendSlaves) {
        this.setCacheValue("append_slaves", appendSlaves);
    }

    public void setDescription(String description) {
        this.setCacheValue("description", description);
    }

    public void setQuota(String quota) {
        this.setCacheValue("quota", quota);
    }

    public void setSlaves(String slaves) {
        this.setCacheValue("slaves", slaves);
    }

    public void setSlaves(String[] slaves) {
        this.setSlaves(Util.join(",", slaves));
    }
}

