/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;

class InsertRootElementFilterInputStream
extends FilterInputStream {
    private static final int REREAD_BUFFER_SIZE = 512;
    private static byte[] resultsTagBytes;
    private final ByteArrayInputStream suffix = new ByteArrayInputStream("</doc>".getBytes("UTF-8"));
    private ByteArrayInputStream beforeResultsBuffer;
    private boolean wrotePrefix;
    private byte[] oneByte = new byte[1];

    InsertRootElementFilterInputStream(InputStream in) throws IOException {
        super(new PushbackInputStream(in, 512));
        PushbackInputStream pin = (PushbackInputStream)this.in;
        ByteArrayOutputStream beforeResultsChars = new ByteArrayOutputStream();
        this.beforeResultsBuffer = new ByteArrayInputStream(new byte[0]);
        while (true) {
            int ch;
            if ((ch = this.in.read()) == -1) {
                this.wrotePrefix = false;
                pin.unread(beforeResultsChars.toByteArray());
                return;
            }
            if (ch == 60) {
                boolean resultsTag = this.isResultsTag(pin);
                if (resultsTag) {
                    pin.unread(resultsTagBytes);
                    pin.unread(ch);
                    beforeResultsChars.write("<doc>".getBytes("UTF-8"));
                    this.beforeResultsBuffer = new ByteArrayInputStream(beforeResultsChars.toByteArray());
                    this.wrotePrefix = true;
                    return;
                }
                beforeResultsChars.write(ch);
                continue;
            }
            beforeResultsChars.write(ch);
        }
    }

    private boolean isResultsTag(PushbackInputStream pin) throws IOException {
        ByteArrayOutputStream atResultsChars = new ByteArrayOutputStream();
        boolean resultsTag = true;
        for (byte b : resultsTagBytes) {
            int ech = this.in.read();
            atResultsChars.write(ech);
            if (ech == b) continue;
            pin.unread(atResultsChars.toByteArray());
            resultsTag = false;
            break;
        }
        return resultsTag;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int result = 0;
        int availableFromBuffer = this.beforeResultsBuffer.available();
        if (offset < availableFromBuffer && length <= (result = this.beforeResultsBuffer.read(buffer, offset, length))) {
            return result;
        }
        if ((result += this.in.read(buffer, offset + result, length - result)) == -1 && this.wrotePrefix) {
            return this.suffix.read(buffer, offset, length);
        }
        return result;
    }

    @Override
    public int read() throws IOException {
        if (this.read(this.oneByte, 0, 1) == -1) {
            return -1;
        }
        return this.oneByte[0];
    }

    static {
        try {
            resultsTagBytes = "results".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

