/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.splunk.Args;
import com.splunk.HttpException;
import com.splunk.RequestMessage;
import com.splunk.ResponseMessage;
import com.splunk.SSLSecurityProtocol;
import com.splunk.SimpleCookieStore;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.URL;
import java.net.URLStreamHandler;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class HttpService {
    private static final boolean VERBOSE_REQUESTS = false;
    protected static SSLSecurityProtocol sslSecurityProtocol = null;
    protected static boolean validateCertificates = true;
    private static SSLSocketFactory sslSocketFactory = HttpService.createSSLFactory();
    private static String HTTPS_SCHEME = "https";
    private static String HTTP_SCHEME = "http";
    private static String HOSTNAME = "localhost";
    private static String HOSTIP = "127.0.0.1";
    private static final HostnameVerifier HOSTNAME_VERIFIER = new HostnameVerifier(){

        @Override
        public boolean verify(String s, SSLSession sslSession) {
            if (s.equals(HOSTNAME) || s.equals(HOSTIP)) {
                return true;
            }
            HostnameVerifier hv = HttpsURLConnection.getDefaultHostnameVerifier();
            return hv.verify(s, sslSession);
        }
    };
    protected URLStreamHandler httpsHandler = null;
    protected String scheme = "https";
    protected String host = "localhost";
    protected int port = 8089;
    protected Integer connectTimeout = null;
    protected Integer readTimeout = null;
    private String prefix = null;
    static Map<String, String> defaultHeader = new HashMap<String, String>(){
        {
            this.put("User-Agent", "splunk-sdk-java/1.9.3");
            this.put("Accept", "*/*");
        }
    };
    protected Map<String, String> customHeaders = new HashMap<String, String>();
    protected SimpleCookieStore cookieStore = new SimpleCookieStore();

    public HttpService() {
    }

    public HttpService(String host) {
        this.host = host;
    }

    public HttpService(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public HttpService(String host, int port, String scheme) {
        this.host = host;
        this.port = port;
        this.scheme = scheme;
    }

    public HttpService(String host, int port, String scheme, URLStreamHandler httpsHandler) {
        this.host = host;
        this.port = port;
        this.scheme = scheme;
        this.httpsHandler = httpsHandler;
    }

    private static int count(Map<String, Object> args) {
        if (args == null) {
            return 0;
        }
        return args.size();
    }

    public ResponseMessage get(String path) {
        return this.send(path, new RequestMessage("GET"));
    }

    public ResponseMessage get(String path, Map<String, Object> args) {
        if (HttpService.count(args) > 0) {
            path = path + "?" + Args.encode(args);
        }
        RequestMessage request = new RequestMessage("GET");
        return this.send(path, request);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void setCustomHeaders(Map<String, String> headers) {
        if (Objects.nonNull(headers)) {
            this.customHeaders = headers;
        }
    }

    public static SSLSecurityProtocol getSslSecurityProtocol() {
        return sslSecurityProtocol;
    }

    public static void setSslSecurityProtocol(SSLSecurityProtocol securityProtocol) {
        if (sslSecurityProtocol != securityProtocol) {
            sslSecurityProtocol = securityProtocol;
            sslSocketFactory = HttpService.createSSLFactory();
        }
    }

    public String getPrefix() {
        if (this.prefix == null) {
            this.prefix = String.format("%s://%s:%s", this.scheme, this.host, this.port);
        }
        return this.prefix;
    }

    public String getScheme() {
        return this.scheme;
    }

    public URL getUrl(String path) {
        try {
            if (HTTPS_SCHEME.equals(this.getScheme()) && this.httpsHandler != null) {
                return new URL(this.getScheme(), this.getHost(), this.getPort(), path, this.httpsHandler);
            }
            return new URL(this.getScheme(), this.getHost(), this.getPort(), path);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public String stringifyCookies() {
        return this.cookieStore.getCookies();
    }

    public void addCookie(String setCookieHeader) {
        this.cookieStore.add(setCookieHeader);
    }

    public void removeAllCookies() {
        this.cookieStore.removeAll();
    }

    public Boolean hasSplunkAuthCookies() {
        return this.cookieStore.hasSplunkAuthCookie();
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    public ResponseMessage post(String path) {
        return this.post(path, null);
    }

    public ResponseMessage post(String path, Map<String, Object> args) {
        RequestMessage request = new RequestMessage("POST");
        request.getHeader().put("Content-Type", "application/x-www-form-urlencoded");
        if (HttpService.count(args) > 0) {
            request.setContent(Args.encode(args));
        }
        return this.send(path, request);
    }

    public ResponseMessage delete(String path) {
        RequestMessage request = new RequestMessage("DELETE");
        return this.send(path, request);
    }

    public ResponseMessage delete(String path, Map<String, Object> args) {
        if (HttpService.count(args) > 0) {
            path = path + "?" + Args.encode(args);
        }
        RequestMessage request = new RequestMessage("DELETE");
        return this.send(path, request);
    }

    Socket open() throws IOException {
        if (this.scheme.equals("https")) {
            return sslSocketFactory.createSocket(this.host, this.port);
        }
        return new Socket(this.host, this.port);
    }

    public ResponseMessage send(String path, RequestMessage request) {
        InputStream input;
        int status;
        HttpURLConnection cn;
        block20: {
            String key;
            URL url = this.getUrl(path);
            try {
                cn = (HttpURLConnection)url.openConnection();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            if (cn instanceof HttpsURLConnection) {
                ((HttpsURLConnection)cn).setSSLSocketFactory(sslSocketFactory);
                ((HttpsURLConnection)cn).setHostnameVerifier(HOSTNAME_VERIFIER);
            }
            cn.setUseCaches(false);
            cn.setAllowUserInteraction(false);
            cn.setConnectTimeout(this.connectTimeout == null ? 0 : this.connectTimeout);
            cn.setReadTimeout(this.readTimeout == null ? 0 : this.readTimeout);
            String method = request.getMethod();
            try {
                cn.setRequestMethod(method);
            }
            catch (ProtocolException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            Map<String, String> header = request.getHeader();
            for (Map.Entry<String, String> entry : header.entrySet()) {
                cn.setRequestProperty(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : defaultHeader.entrySet()) {
                key = entry.getKey();
                if (header.containsKey(key)) continue;
                cn.setRequestProperty(key, entry.getValue());
            }
            for (Map.Entry<String, String> entry : this.customHeaders.entrySet()) {
                key = entry.getKey();
                if (header.containsKey(key)) continue;
                cn.setRequestProperty(key, entry.getValue());
            }
            cn.setRequestProperty("Cookie", this.cookieStore.getCookies());
            try {
                Object content = request.getContent();
                if (content != null) {
                    cn.setDoOutput(true);
                    OutputStream stream = cn.getOutputStream();
                    OutputStreamWriter writer = new OutputStreamWriter(stream, "UTF-8");
                    writer.write((String)content);
                    writer.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            try {
                cn.connect();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            try {
                status = cn.getResponseCode();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            input = null;
            try {
                input = status >= 400 ? cn.getErrorStream() : cn.getInputStream();
            }
            catch (IOException e) {
                if ($assertionsDisabled) break block20;
                throw new AssertionError();
            }
        }
        Map<String, List<String>> headers = cn.getHeaderFields();
        if (headers.containsKey("Set-Cookie")) {
            for (String cookieHeader : headers.get("Set-Cookie")) {
                if (cookieHeader == null || cookieHeader.length() <= 0) continue;
                this.cookieStore.add(cookieHeader);
            }
        }
        ResponseMessage response = new ResponseMessage(status, input);
        if (status >= 400) {
            throw HttpException.create(response);
        }
        return response;
    }

    public static void setSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        if (sslSocketFactory == null) {
            throw new IllegalArgumentException("The sslSocketFactory cannot be null.");
        }
        HttpService.sslSocketFactory = sslSocketFactory;
    }

    public static SSLSocketFactory getSSLSocketFactory() {
        return sslSocketFactory;
    }

    public static void setValidateCertificates(boolean validateCertificates) {
        HttpService.validateCertificates = validateCertificates;
    }

    public static SSLSocketFactory createSSLFactory() {
        try {
            SSLContext context;
            if (sslSecurityProtocol != null) {
                String contextStr = sslSecurityProtocol.toString().contains("SSL") ? "SSL" : "TLS";
                context = SSLContext.getInstance(contextStr);
            } else {
                context = System.getProperty("java.version").compareTo("1.8") >= 0 ? SSLContext.getInstance("TLS") : SSLContext.getDefault();
            }
            if (validateCertificates) {
                context.init(null, null, null);
            } else {
                TrustManager[] trustAll = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                context.init(null, trustAll, null);
            }
            return context.getSocketFactory();
        }
        catch (Exception e) {
            throw new RuntimeException("Error setting up SSL socket factory: " + e, e);
        }
    }
}

