/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.splunk.Entity;
import com.splunk.Record;

public class EntityMetadata {
    private Entity entity;

    EntityMetadata(Entity entity) {
        this.entity = entity;
    }

    public boolean canChangePermissions() {
        return this.getEaiAcl().getBoolean("can_change_perms", false);
    }

    public boolean canShareApp() {
        return this.getEaiAcl().getBoolean("can_share_app", false);
    }

    public boolean canShareGlobal() {
        return this.getEaiAcl().getBoolean("can_share_global", false);
    }

    public boolean canShareUser() {
        return this.getEaiAcl().getBoolean("can_share_user", false);
    }

    public boolean canWrite() {
        return this.getEaiAcl().getBoolean("can_write", false);
    }

    public String getApp() {
        return this.getEaiAcl().getString("app", "system");
    }

    Record getEaiAcl() {
        return (Record)this.entity.validate().get("eai:acl");
    }

    public String getOwner() {
        return this.getEaiAcl().getString("owner");
    }

    public Record getPermissions() {
        return this.getEaiAcl().getValue("perms", null);
    }

    public String getSharing() {
        return this.getEaiAcl().getString("sharing");
    }

    public boolean isModifiable() {
        return this.getEaiAcl().getBoolean("modifiable", false);
    }
}

