/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.storage.ql.exec.vector;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.orc.storage.ql.exec.vector.ColumnVector;
import org.apache.orc.storage.ql.exec.vector.LongColumnVector;

public class DateColumnVector
extends LongColumnVector {
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final GregorianCalendar PROLEPTIC_GREGORIAN_CALENDAR = new GregorianCalendar(UTC);
    private static final GregorianCalendar GREGORIAN_CALENDAR = new GregorianCalendar(UTC);
    private static final SimpleDateFormat PROLEPTIC_GREGORIAN_DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat GREGORIAN_DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd");
    private static final int CUTOVER_DAY_EPOCH = -141427;
    private boolean usingProlepticCalendar = false;

    public DateColumnVector() {
        this(1024);
    }

    public void changeCalendar(boolean useProleptic, boolean updateData) {
        if (useProleptic == this.usingProlepticCalendar) {
            return;
        }
        this.usingProlepticCalendar = useProleptic;
        if (updateData) {
            try {
                this.updateDataAccordingProlepticSetting();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void updateDataAccordingProlepticSetting() throws Exception {
        for (int i = 0; i < this.vector.length; ++i) {
            if (this.vector[i] >= -141427L) continue;
            long millis = TimeUnit.DAYS.toMillis(this.vector[i]);
            String originalFormatted = this.usingProlepticCalendar ? GREGORIAN_DATE_FORMATTER.format(millis) : PROLEPTIC_GREGORIAN_DATE_FORMATTER.format(millis);
            millis = (this.usingProlepticCalendar ? PROLEPTIC_GREGORIAN_DATE_FORMATTER.parse(originalFormatted) : GREGORIAN_DATE_FORMATTER.parse(originalFormatted)).getTime();
            this.vector[i] = TimeUnit.MILLISECONDS.toDays(millis);
        }
    }

    public String formatDate(int i) {
        long millis = TimeUnit.DAYS.toMillis(this.vector[i]);
        return this.usingProlepticCalendar ? PROLEPTIC_GREGORIAN_DATE_FORMATTER.format(millis) : GREGORIAN_DATE_FORMATTER.format(millis);
    }

    public DateColumnVector setUsingProlepticCalendar(boolean usingProlepticCalendar) {
        this.usingProlepticCalendar = usingProlepticCalendar;
        return this;
    }

    public boolean isUsingProlepticCalendar() {
        return this.usingProlepticCalendar;
    }

    public DateColumnVector(int len) {
        super(len);
    }

    @Override
    public void shallowCopyTo(ColumnVector otherCv) {
        DateColumnVector other = (DateColumnVector)otherCv;
        super.shallowCopyTo(other);
        other.vector = this.vector;
    }

    static {
        PROLEPTIC_GREGORIAN_CALENDAR.setGregorianChange(new Date(Long.MIN_VALUE));
        PROLEPTIC_GREGORIAN_DATE_FORMATTER.setCalendar(PROLEPTIC_GREGORIAN_CALENDAR);
        GREGORIAN_DATE_FORMATTER.setCalendar(GREGORIAN_CALENDAR);
    }
}

