/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.iceberg.schema;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.drill.metastore.MetastoreColumn;
import org.apache.drill.metastore.MetastoreFieldDefinition;
import org.apache.drill.metastore.iceberg.exceptions.IcebergMetastoreException;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergTableSchema {
    private static final Logger logger = LoggerFactory.getLogger(IcebergTableSchema.class);
    public static final int STARTING_SCHEMA_INDEX = 1;
    public static final int STARTING_COMPLEX_TYPES_INDEX = 10000;
    private static final Map<String, Type> JAVA_TO_ICEBERG_TYPE_MAP = ImmutableMap.builder().put((Object)"string", (Object)Types.StringType.get()).put((Object)"int", (Object)Types.IntegerType.get()).put((Object)"integer", (Object)Types.IntegerType.get()).put((Object)"long", (Object)Types.LongType.get()).put((Object)"float", (Object)Types.FloatType.get()).put((Object)"double", (Object)Types.DoubleType.get()).put((Object)"boolean", (Object)Types.BooleanType.get()).build();
    private final Schema tableSchema;
    private final PartitionSpec partitionSpec;

    public IcebergTableSchema(Schema tableSchema, PartitionSpec partitionSpec) {
        this.tableSchema = tableSchema;
        this.partitionSpec = partitionSpec;
    }

    public static IcebergTableSchema of(Class<?> clazz, List<MetastoreColumn> partitionKeys) {
        ArrayList<Types.NestedField> tableSchemaFields = new ArrayList<Types.NestedField>();
        Types.NestedField[] partitionSpecSchemaFields = new Types.NestedField[partitionKeys.size()];
        int schemaIndex = 1;
        int complexTypesIndex = 10000;
        for (Field field : clazz.getDeclaredFields()) {
            MetastoreFieldDefinition definition = field.getAnnotation(MetastoreFieldDefinition.class);
            if (definition == null) continue;
            MetastoreColumn column = definition.column();
            String typeSimpleName = field.getType().getSimpleName().toLowerCase();
            Type icebergType = JAVA_TO_ICEBERG_TYPE_MAP.get(typeSimpleName);
            if (icebergType == null && field.getAnnotatedType().getType() instanceof ParameterizedType) {
                java.lang.reflect.Type[] actualTypeArguments = ((ParameterizedType)field.getAnnotatedType().getType()).getActualTypeArguments();
                switch (typeSimpleName) {
                    case "list": {
                        Type listIcebergType = IcebergTableSchema.getGenericsType(actualTypeArguments[0]);
                        icebergType = Types.ListType.ofOptional((int)complexTypesIndex++, (Type)listIcebergType);
                        break;
                    }
                    case "map": {
                        Type keyIcebergType = IcebergTableSchema.getGenericsType(actualTypeArguments[0]);
                        Type valueIcebergType = IcebergTableSchema.getGenericsType(actualTypeArguments[1]);
                        icebergType = Types.MapType.ofOptional((int)complexTypesIndex++, (int)complexTypesIndex++, (Type)keyIcebergType, (Type)valueIcebergType);
                        break;
                    }
                    default: {
                        throw new IcebergMetastoreException(String.format("Unexpected parametrized type for class [%s]: %s", clazz.getCanonicalName(), typeSimpleName));
                    }
                }
            }
            if (icebergType == null) {
                throw new IcebergMetastoreException(String.format("Unexpected type for class [%s]: %s", clazz.getCanonicalName(), typeSimpleName));
            }
            Types.NestedField icebergField = Types.NestedField.optional((int)schemaIndex++, (String)column.columnName(), (Type)icebergType);
            tableSchemaFields.add(icebergField);
            int partitionIndex = partitionKeys.indexOf(column);
            if (partitionIndex == -1) continue;
            partitionSpecSchemaFields[partitionIndex] = icebergField;
        }
        if (Stream.of(partitionSpecSchemaFields).anyMatch(Objects::isNull)) {
            throw new IcebergMetastoreException(String.format("Some of partition fields are missing in the class [%s]. Partition keys: %s. Partition values: %s.", clazz.getCanonicalName(), partitionKeys, Arrays.asList(partitionSpecSchemaFields)));
        }
        Schema tableSchema = new Schema(tableSchemaFields);
        PartitionSpec partitionSpec = IcebergTableSchema.buildPartitionSpec(partitionSpecSchemaFields);
        logger.debug("Constructed Iceberg table schema for class [{}]. Table schema : {}. Partition spec: {}.", new Object[]{clazz.getCanonicalName(), tableSchema, partitionSpec});
        return new IcebergTableSchema(tableSchema, partitionSpec);
    }

    public Schema tableSchema() {
        return this.tableSchema;
    }

    public PartitionSpec partitionSpec() {
        return this.partitionSpec;
    }

    private static Type getGenericsType(java.lang.reflect.Type type) {
        if (!(type instanceof Class)) {
            throw new IcebergMetastoreException("Unexpected generics type: " + type.getTypeName());
        }
        Class typeArgument = (Class)type;
        String typeSimpleName = typeArgument.getSimpleName().toLowerCase();
        Type icebergType = JAVA_TO_ICEBERG_TYPE_MAP.get(typeSimpleName);
        if (icebergType == null) {
            throw new IcebergMetastoreException("Unexpected type: " + typeSimpleName);
        }
        return icebergType;
    }

    private static PartitionSpec buildPartitionSpec(Types.NestedField[] partitionFields) {
        Schema schema = new Schema(partitionFields);
        if (schema.columns().isEmpty()) {
            return PartitionSpec.unpartitioned();
        }
        PartitionSpec.Builder builder = PartitionSpec.builderFor((Schema)schema);
        schema.columns().forEach(column -> builder.identity(column.name()));
        return builder.build();
    }
}

