/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.iceberg.components.tables;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.drill.metastore.MetastoreColumn;
import org.apache.drill.metastore.components.tables.TableMetadataUnit;
import org.apache.drill.metastore.iceberg.IcebergMetastoreContext;
import org.apache.drill.metastore.iceberg.components.tables.TableKey;
import org.apache.drill.metastore.iceberg.operate.Overwrite;
import org.apache.drill.metastore.iceberg.transform.OperationTransformer;
import org.apache.iceberg.expressions.Expression;

public class TablesOperationTransformer
extends OperationTransformer<TableMetadataUnit> {
    public TablesOperationTransformer(IcebergMetastoreContext<TableMetadataUnit> context) {
        super(context);
    }

    @Override
    public List<Overwrite> toOverwrite(List<TableMetadataUnit> units) {
        Map<TableKey, Map<String, List<TableMetadataUnit>>> data = units.stream().collect(Collectors.groupingBy(TableKey::of, Collectors.groupingBy(TableMetadataUnit::metadataKey)));
        return data.entrySet().parallelStream().map(dataEntry -> ((Map)dataEntry.getValue()).entrySet().parallelStream().map(operationEntry -> {
            TableKey tableKey = (TableKey)dataEntry.getKey();
            String location = tableKey.toLocation(this.context.table().location());
            HashMap<MetastoreColumn, Object> filterConditions = new HashMap<MetastoreColumn, Object>(tableKey.toFilterConditions());
            filterConditions.put(MetastoreColumn.METADATA_KEY, operationEntry.getKey());
            Expression expression = this.context.transformer().filter().transform(filterConditions);
            return this.toOverwrite(location, expression, (List)operationEntry.getValue());
        }).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

