/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.tls.HandshakeMessageInput;
import org.bouncycastle.tls.TlsUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ByteQueue {
    private byte[] databuf;
    private int skipped = 0;
    private int available = 0;
    private boolean readOnlyBuf = false;

    public static int nextTwoPow(int i) {
        i |= i >> 1;
        i |= i >> 2;
        i |= i >> 4;
        i |= i >> 8;
        i |= i >> 16;
        return i + 1;
    }

    public ByteQueue() {
        this(0);
    }

    public ByteQueue(int capacity) {
        this.databuf = capacity == 0 ? TlsUtils.EMPTY_BYTES : new byte[capacity];
    }

    public ByteQueue(byte[] buf, int off, int len) {
        this.databuf = buf;
        this.skipped = off;
        this.available = len;
        this.readOnlyBuf = true;
    }

    public void addData(byte[] buf, int off, int len) {
        if (this.readOnlyBuf) {
            throw new IllegalStateException("Cannot add data to read-only buffer");
        }
        if (this.skipped + this.available + len > this.databuf.length) {
            int desiredSize = ByteQueue.nextTwoPow(this.available + len);
            if (desiredSize > this.databuf.length) {
                byte[] tmp = new byte[desiredSize];
                System.arraycopy(this.databuf, this.skipped, tmp, 0, this.available);
                this.databuf = tmp;
            } else {
                System.arraycopy(this.databuf, this.skipped, this.databuf, 0, this.available);
            }
            this.skipped = 0;
        }
        System.arraycopy(buf, off, this.databuf, this.skipped + this.available, len);
        this.available += len;
    }

    public int available() {
        return this.available;
    }

    public void copyTo(OutputStream output, int length) throws IOException {
        if (length > this.available) {
            throw new IllegalStateException("Cannot copy " + length + " bytes, only got " + this.available);
        }
        output.write(this.databuf, this.skipped, length);
    }

    public void read(byte[] buf, int offset, int len, int skip) {
        if (buf.length - offset < len) {
            throw new IllegalArgumentException("Buffer size of " + buf.length + " is too small for a read of " + len + " bytes");
        }
        if (this.available - skip < len) {
            throw new IllegalStateException("Not enough data to read");
        }
        System.arraycopy(this.databuf, this.skipped + skip, buf, offset, len);
    }

    public HandshakeMessageInput readHandshakeMessage(int length) {
        if (length > this.available) {
            throw new IllegalStateException("Cannot read " + length + " bytes, only got " + this.available);
        }
        int position = this.skipped;
        this.available -= length;
        this.skipped += length;
        return new HandshakeMessageInput(this.databuf, position, length);
    }

    public int readInt32() {
        if (this.available < 4) {
            throw new IllegalStateException("Not enough data to read");
        }
        return TlsUtils.readInt32(this.databuf, this.skipped);
    }

    public void removeData(int i) {
        if (i > this.available) {
            throw new IllegalStateException("Cannot remove " + i + " bytes, only got " + this.available);
        }
        this.available -= i;
        this.skipped += i;
    }

    public void removeData(byte[] buf, int off, int len, int skip) {
        this.read(buf, off, len, skip);
        this.removeData(skip + len);
    }

    public byte[] removeData(int len, int skip) {
        byte[] buf = new byte[len];
        this.removeData(buf, 0, len, skip);
        return buf;
    }

    public void shrink() {
        if (this.available == 0) {
            this.databuf = TlsUtils.EMPTY_BYTES;
            this.skipped = 0;
        } else {
            int desiredSize = ByteQueue.nextTwoPow(this.available);
            if (desiredSize < this.databuf.length) {
                byte[] tmp = new byte[desiredSize];
                System.arraycopy(this.databuf, this.skipped, tmp, 0, this.available);
                this.databuf = tmp;
                this.skipped = 0;
            }
        }
    }
}

