/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.JsseSessionParameters;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.ProvSSLSession;
import org.bouncycastle.tls.SessionID;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvSSLSessionContext
implements SSLSessionContext {
    private static final Logger LOG = Logger.getLogger(ProvSSLSessionContext.class.getName());
    private static final int provSessionCacheSize = PropertyUtils.getIntegerSystemProperty("javax.net.ssl.sessionCacheSize", 20480, 0, Integer.MAX_VALUE);
    protected final Map<SessionID, SessionEntry> sessionsByID = new LinkedHashMap<SessionID, SessionEntry>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<SessionID, SessionEntry> eldest) {
            boolean shouldRemove;
            boolean bl = shouldRemove = ProvSSLSessionContext.this.sessionCacheSize > 0 && this.size() > ProvSSLSessionContext.this.sessionCacheSize;
            if (shouldRemove) {
                ProvSSLSessionContext.this.removeSessionByPeer(eldest.getValue());
            }
            return shouldRemove;
        }
    };
    protected final Map<String, SessionEntry> sessionsByPeer = new HashMap<String, SessionEntry>();
    protected final ReferenceQueue<ProvSSLSession> sessionsQueue = new ReferenceQueue();
    protected final ContextData contextData;
    protected int sessionCacheSize = provSessionCacheSize;
    protected int sessionTimeoutSeconds = 86400;

    ProvSSLSessionContext(ContextData contextData) {
        this.contextData = contextData;
    }

    ProvSSLContextSpi getSSLContext() {
        return this.contextData.getContext();
    }

    JcaTlsCrypto getCrypto() {
        return this.contextData.getCrypto();
    }

    synchronized ProvSSLSession getSessionImpl(byte[] sessionID) {
        this.processQueue();
        return this.accessSession(ProvSSLSessionContext.mapGet(this.sessionsByID, ProvSSLSessionContext.makeSessionID(sessionID)));
    }

    synchronized ProvSSLSession getSessionImpl(String hostName, int port) {
        this.processQueue();
        SessionEntry sessionEntry = ProvSSLSessionContext.mapGet(this.sessionsByPeer, ProvSSLSessionContext.makePeerKey(hostName, port));
        ProvSSLSession session = this.accessSession(sessionEntry);
        if (session != null) {
            this.sessionsByID.get(sessionEntry.getSessionID());
        }
        return session;
    }

    synchronized void removeSession(byte[] sessionID) {
        SessionEntry sessionEntry = ProvSSLSessionContext.mapRemove(this.sessionsByID, ProvSSLSessionContext.makeSessionID(sessionID));
        if (null != sessionEntry) {
            this.removeSessionByPeer(sessionEntry);
        }
    }

    synchronized ProvSSLSession reportSession(String peerHost, int peerPort, TlsSession tlsSession, JsseSessionParameters jsseSessionParameters, boolean addToCache) {
        ProvSSLSession session;
        this.processQueue();
        if (!addToCache) {
            return new ProvSSLSession(this, peerHost, peerPort, tlsSession, jsseSessionParameters);
        }
        SessionID sessionID = ProvSSLSessionContext.makeSessionID(tlsSession.getSessionID());
        SessionEntry sessionEntry = ProvSSLSessionContext.mapGet(this.sessionsByID, sessionID);
        ProvSSLSession provSSLSession = session = sessionEntry == null ? null : (ProvSSLSession)sessionEntry.get();
        if (null == session || session.getTlsSession() != tlsSession) {
            session = new ProvSSLSession(this, peerHost, peerPort, tlsSession, jsseSessionParameters);
            if (null != sessionID) {
                sessionEntry = new SessionEntry(sessionID, session, this.sessionsQueue);
                this.sessionsByID.put(sessionID, sessionEntry);
            }
        }
        if (null != sessionEntry) {
            ProvSSLSessionContext.mapAdd(this.sessionsByPeer, sessionEntry.getPeerKey(), sessionEntry);
        }
        return session;
    }

    @Override
    public synchronized Enumeration<byte[]> getIds() {
        this.removeAllExpiredSessions();
        ArrayList<byte[]> ids = new ArrayList<byte[]>(this.sessionsByID.size());
        for (SessionID sessionID : this.sessionsByID.keySet()) {
            ids.add(sessionID.getBytes());
        }
        return Collections.enumeration(ids);
    }

    @Override
    public SSLSession getSession(byte[] sessionID) {
        if (sessionID == null) {
            throw new NullPointerException("'sessionID' cannot be null");
        }
        return this.getSessionImpl(sessionID);
    }

    @Override
    public synchronized int getSessionCacheSize() {
        return this.sessionCacheSize;
    }

    @Override
    public synchronized int getSessionTimeout() {
        return this.sessionTimeoutSeconds;
    }

    @Override
    public synchronized void setSessionCacheSize(int size) throws IllegalArgumentException {
        int currentSize;
        if (this.sessionCacheSize == size) {
            return;
        }
        if (size < 0) {
            throw new IllegalArgumentException("'size' cannot be < 0");
        }
        this.sessionCacheSize = size;
        this.removeAllExpiredSessions();
        if (this.sessionCacheSize > 0 && (currentSize = this.sessionsByID.size()) > this.sessionCacheSize) {
            Iterator<SessionEntry> iter = this.sessionsByID.values().iterator();
            while (iter.hasNext() && currentSize > this.sessionCacheSize) {
                SessionEntry sessionEntry = iter.next();
                iter.remove();
                this.removeSessionByPeer(sessionEntry);
                --currentSize;
            }
        }
    }

    @Override
    public synchronized void setSessionTimeout(int seconds) throws IllegalArgumentException {
        if (this.sessionTimeoutSeconds == seconds) {
            return;
        }
        if (seconds < 0) {
            throw new IllegalArgumentException("'seconds' cannot be < 0");
        }
        this.sessionTimeoutSeconds = seconds;
        this.removeAllExpiredSessions();
    }

    private ProvSSLSession accessSession(SessionEntry sessionEntry) {
        if (sessionEntry != null) {
            long currentTimeMillis;
            ProvSSLSession session = (ProvSSLSession)sessionEntry.get();
            if (session != null && !this.invalidateIfCreatedBefore(sessionEntry, this.getCreationTimeLimit(currentTimeMillis = System.currentTimeMillis()))) {
                session.accessedAt(currentTimeMillis);
                return session;
            }
            this.removeSession(sessionEntry);
        }
        return null;
    }

    private long getCreationTimeLimit(long expiryTimeMillis) {
        return this.sessionTimeoutSeconds < 1 ? Long.MIN_VALUE : expiryTimeMillis - 1000L * (long)this.sessionTimeoutSeconds;
    }

    private boolean invalidateIfCreatedBefore(SessionEntry sessionEntry, long creationTimeLimit) {
        ProvSSLSession session = (ProvSSLSession)sessionEntry.get();
        if (session == null) {
            return true;
        }
        if (session.getCreationTime() < creationTimeLimit) {
            session.invalidate();
        }
        return !session.isValid();
    }

    private void processQueue() {
        SessionEntry sessionEntry;
        int count = 0;
        while ((sessionEntry = (SessionEntry)this.sessionsQueue.poll()) != null) {
            this.removeSession(sessionEntry);
            ++count;
        }
        if (count > 0) {
            LOG.fine("Processed " + count + " session entries (soft references) from the reference queue");
        }
    }

    private void removeAllExpiredSessions() {
        this.processQueue();
        long creationTimeLimit = this.getCreationTimeLimit(System.currentTimeMillis());
        Iterator<SessionEntry> iter = this.sessionsByID.values().iterator();
        while (iter.hasNext()) {
            SessionEntry sessionEntry = iter.next();
            if (!this.invalidateIfCreatedBefore(sessionEntry, creationTimeLimit)) continue;
            iter.remove();
            this.removeSessionByPeer(sessionEntry);
        }
    }

    private void removeSession(SessionEntry sessionEntry) {
        ProvSSLSessionContext.mapRemove(this.sessionsByID, sessionEntry.getSessionID(), sessionEntry);
        this.removeSessionByPeer(sessionEntry);
    }

    private boolean removeSessionByPeer(SessionEntry sessionEntry) {
        return ProvSSLSessionContext.mapRemove(this.sessionsByPeer, sessionEntry.getPeerKey(), sessionEntry);
    }

    private static String makePeerKey(ProvSSLSession session) {
        return session == null ? null : ProvSSLSessionContext.makePeerKey(session.getPeerHost(), session.getPeerPort());
    }

    private static String makePeerKey(String hostName, int port) {
        return hostName == null || port < 0 ? null : (hostName + ':' + Integer.toString(port)).toLowerCase(Locale.ENGLISH);
    }

    private static SessionID makeSessionID(byte[] sessionID) {
        return TlsUtils.isNullOrEmpty(sessionID) ? null : new SessionID(sessionID);
    }

    private static <K, V> void mapAdd(Map<K, V> map, K key, V value) {
        if (map == null || value == null) {
            throw new NullPointerException();
        }
        if (key != null) {
            map.put(key, value);
        }
    }

    private static <K, V> V mapGet(Map<K, V> map, K key) {
        if (map == null) {
            throw new NullPointerException();
        }
        return key == null ? null : (V)map.get(key);
    }

    private static <K, V> V mapRemove(Map<K, V> map, K key) {
        if (map == null) {
            throw new NullPointerException();
        }
        return key == null ? null : (V)map.remove(key);
    }

    private static <K, V> boolean mapRemove(Map<K, V> map, K key, V value) {
        if (map == null || value == null) {
            throw new NullPointerException();
        }
        if (key != null) {
            V removed = map.remove(key);
            if (removed == value) {
                return true;
            }
            if (removed != null) {
                map.put(key, removed);
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class SessionEntry
    extends SoftReference<ProvSSLSession> {
        private final SessionID sessionID;
        private final String peerKey;

        SessionEntry(SessionID sessionID, ProvSSLSession session, ReferenceQueue<ProvSSLSession> queue) {
            super(session, queue);
            if (sessionID == null || session == null || queue == null) {
                throw new NullPointerException();
            }
            this.sessionID = sessionID;
            this.peerKey = ProvSSLSessionContext.makePeerKey(session);
        }

        public String getPeerKey() {
            return this.peerKey;
        }

        public SessionID getSessionID() {
            return this.sessionID;
        }
    }
}

