/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.iceberg.operate;

import java.util.Map;
import org.apache.iceberg.Table;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.util.PropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpirationHandler {
    private static final Logger logger = LoggerFactory.getLogger(ExpirationHandler.class);
    private final Table table;
    private final boolean shouldExpire;
    private final int retainNumber;

    public ExpirationHandler(Table table) {
        this.table = table;
        Map properties = table.properties();
        this.shouldExpire = PropertyUtil.propertyAsBoolean((Map)properties, (String)"write.metadata.delete-after-commit.enabled", (boolean)false);
        this.retainNumber = PropertyUtil.propertyAsInt((Map)properties, (String)"write.metadata.previous-versions-max", (int)100);
    }

    public void expire() {
        if (this.shouldExpire) {
            this.table.expireSnapshots().expireOlderThan(System.currentTimeMillis()).retainLast(this.retainNumber).commit();
        }
    }

    public void expireQuietly() {
        try {
            this.expire();
        }
        catch (CommitFailedException | ValidationException e) {
            logger.warn("Unable to expire snapshots: {}", (Object)e.getMessage());
            logger.debug("Error when expiring snapshots", e);
        }
    }
}

