/*
 * Decompiled with CFR 0.152.
 */
package org.ojai.json.impl;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.ojai.DocumentReader;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.ojai.exceptions.TypeException;
import org.ojai.json.Json;
import org.ojai.json.JsonOptions;
import org.ojai.json.impl.JsonDOMDocumentReader;
import org.ojai.json.impl.JsonDocument;
import org.ojai.json.impl.JsonList;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

@API.Internal
public class JsonValue
implements Value {
    Value.Type valueType;
    long jsonValue;
    Object objValue;
    String key;

    JsonValue() {
    }

    JsonValue(Value.Type t) {
        this.valueType = t;
    }

    JsonValue(Object o, Value.Type t) {
        this.objValue = o;
        this.valueType = t;
    }

    JsonValue(boolean bool, Value.Type t) {
        this.valueType = t;
        this.jsonValue = bool ? 1L : 0L;
    }

    JsonValue(long l, Value.Type t) {
        this.jsonValue = l;
        this.valueType = t;
    }

    JsonValue(int l, Value.Type t) {
        this.jsonValue = l;
        this.valueType = t;
    }

    void setKey(String k) {
        this.key = k;
    }

    String getKey() {
        return this.key;
    }

    private void checkType(Value.Type t) throws TypeException {
        if (this.valueType != t) {
            throw new TypeException("Value is of type " + (Object)((Object)this.valueType) + " but requested type is " + (Object)((Object)t));
        }
    }

    void setPrimValue(long value) {
        this.jsonValue = value;
    }

    void setObjValue(Object value) {
        this.objValue = value;
    }

    @Override
    public Object getObject() {
        switch (this.valueType) {
            case BOOLEAN: {
                return new Boolean(this.getBoolean());
            }
            case BYTE: {
                return new Byte(this.getByte());
            }
            case SHORT: {
                return new Short(this.getShort());
            }
            case INT: {
                return new Integer(this.getInt());
            }
            case LONG: {
                return new Long(this.getLong());
            }
            case FLOAT: {
                return new Float(this.getFloat());
            }
            case DOUBLE: {
                return new Double(this.getDouble());
            }
            case TIME: {
                return this.getTime();
            }
            case TIMESTAMP: {
                return this.getTimestamp();
            }
            case DATE: {
                return this.getDate();
            }
            case INTERVAL: {
                return this.getInterval();
            }
            case BINARY: 
            case DECIMAL: 
            case STRING: 
            case NULL: {
                return this.objValue;
            }
            case MAP: 
            case ARRAY: {
                return this;
            }
        }
        throw new TypeException("Invalid type " + (Object)((Object)this.valueType));
    }

    @Override
    public Value.Type getType() {
        return this.valueType;
    }

    @Override
    public byte getByte() {
        switch (this.valueType) {
            case BYTE: {
                return (byte)(this.jsonValue & 0xFFL);
            }
            case SHORT: {
                return (byte)this.getShort();
            }
            case INT: {
                return (byte)this.getInt();
            }
            case LONG: {
                return (byte)this.getLong();
            }
            case FLOAT: {
                return (byte)this.getFloat();
            }
            case DOUBLE: {
                return (byte)this.getDouble();
            }
            case DECIMAL: {
                return ((BigDecimal)this.objValue).byteValue();
            }
        }
        throw new TypeException("Expected a numeric type, found: " + (Object)((Object)this.valueType));
    }

    @Override
    public short getShort() {
        switch (this.valueType) {
            case SHORT: {
                return (short)(this.jsonValue & 0xFFFFL);
            }
            case BYTE: {
                return this.getByte();
            }
            case INT: {
                return (short)this.getInt();
            }
            case LONG: {
                return (short)this.getLong();
            }
            case FLOAT: {
                return (short)this.getFloat();
            }
            case DOUBLE: {
                return (short)this.getDouble();
            }
            case DECIMAL: {
                return ((BigDecimal)this.objValue).shortValue();
            }
        }
        throw new TypeException("Expected a numeric type, found: " + (Object)((Object)this.valueType));
    }

    @Override
    public int getInt() {
        switch (this.valueType) {
            case INT: {
                return (int)(this.jsonValue & 0xFFFFFFFFL);
            }
            case BYTE: {
                return this.getByte();
            }
            case SHORT: {
                return this.getShort();
            }
            case LONG: {
                return (int)this.getLong();
            }
            case FLOAT: {
                return (int)this.getFloat();
            }
            case DOUBLE: {
                return (int)this.getDouble();
            }
            case DECIMAL: {
                return ((BigDecimal)this.objValue).intValue();
            }
        }
        throw new TypeException("Expected a numeric type, found: " + (Object)((Object)this.valueType));
    }

    @Override
    public long getLong() {
        switch (this.valueType) {
            case LONG: {
                return this.jsonValue;
            }
            case BYTE: {
                return this.getByte();
            }
            case SHORT: {
                return this.getShort();
            }
            case INT: {
                return this.getInt();
            }
            case FLOAT: {
                return (long)this.getFloat();
            }
            case DOUBLE: {
                return (long)this.getDouble();
            }
            case DECIMAL: {
                return ((BigDecimal)this.objValue).longValue();
            }
        }
        throw new TypeException("Expected a numeric type, found: " + (Object)((Object)this.valueType));
    }

    @Override
    public float getFloat() {
        switch (this.valueType) {
            case FLOAT: {
                return Float.intBitsToFloat((int)(this.jsonValue & 0xFFFFFFFFL));
            }
            case BYTE: {
                return this.getByte();
            }
            case SHORT: {
                return this.getShort();
            }
            case INT: {
                return this.getInt();
            }
            case LONG: {
                return this.getLong();
            }
            case DOUBLE: {
                return (float)this.getDouble();
            }
            case DECIMAL: {
                return ((BigDecimal)this.objValue).floatValue();
            }
        }
        throw new TypeException("Expected a numeric type, found: " + (Object)((Object)this.valueType));
    }

    @Override
    public double getDouble() {
        switch (this.valueType) {
            case DOUBLE: {
                return Double.longBitsToDouble(this.jsonValue);
            }
            case FLOAT: {
                return this.getFloat();
            }
            case BYTE: {
                return this.getByte();
            }
            case SHORT: {
                return this.getShort();
            }
            case INT: {
                return this.getInt();
            }
            case LONG: {
                return this.getLong();
            }
            case DECIMAL: {
                return ((BigDecimal)this.objValue).doubleValue();
            }
        }
        throw new TypeException("Expected a numeric type, found: " + (Object)((Object)this.valueType));
    }

    @Override
    public BigDecimal getDecimal() {
        switch (this.valueType) {
            case DECIMAL: {
                return (BigDecimal)this.objValue;
            }
            case DOUBLE: {
                return new BigDecimal(this.getDouble());
            }
            case FLOAT: {
                return new BigDecimal(this.getFloat());
            }
            case BYTE: {
                return new BigDecimal(this.getByte());
            }
            case SHORT: {
                return new BigDecimal(this.getShort());
            }
            case INT: {
                return new BigDecimal(this.getInt());
            }
            case LONG: {
                return new BigDecimal(this.getLong());
            }
        }
        throw new TypeException("Expected a numeric type, found: " + (Object)((Object)this.valueType));
    }

    @Override
    public boolean getBoolean() {
        this.checkType(Value.Type.BOOLEAN);
        return this.jsonValue != 0L;
    }

    @Override
    public String getString() {
        this.checkType(Value.Type.STRING);
        return (String)this.objValue;
    }

    @Override
    public OTimestamp getTimestamp() {
        this.checkType(Value.Type.TIMESTAMP);
        if (this.objValue == null) {
            this.objValue = new OTimestamp(this.jsonValue);
        }
        return (OTimestamp)this.objValue;
    }

    @Override
    public long getTimestampAsLong() {
        return this.jsonValue;
    }

    @Override
    public ODate getDate() {
        this.checkType(Value.Type.DATE);
        if (this.objValue == null) {
            this.objValue = ODate.fromDaysSinceEpoch((int)this.jsonValue);
        }
        return (ODate)this.objValue;
    }

    @Override
    public int getDateAsInt() {
        return (int)this.jsonValue;
    }

    @Override
    public OTime getTime() {
        this.checkType(Value.Type.TIME);
        if (this.objValue == null) {
            this.objValue = OTime.fromMillisOfDay((int)this.jsonValue);
        }
        return (OTime)this.objValue;
    }

    @Override
    public int getTimeAsInt() {
        return (int)this.jsonValue;
    }

    @Override
    public OInterval getInterval() {
        this.checkType(Value.Type.INTERVAL);
        if (this.objValue == null) {
            OInterval t = new OInterval(this.jsonValue);
            this.objValue = t;
        }
        return (OInterval)this.objValue;
    }

    @Override
    public long getIntervalAsLong() {
        return this.jsonValue;
    }

    @Override
    public ByteBuffer getBinary() {
        this.checkType(Value.Type.BINARY);
        return ((ByteBuffer)this.objValue).slice();
    }

    @Override
    public Map<String, Object> getMap() {
        this.checkType(Value.Type.MAP);
        return (JsonDocument)this;
    }

    @Override
    public List<Object> getList() {
        this.checkType(Value.Type.ARRAY);
        return (JsonList)this;
    }

    @Override
    public DocumentReader asReader() {
        return new JsonDOMDocumentReader(this);
    }

    JsonValue shallowCopy() {
        JsonValue newKeyValue = new JsonValue(this.valueType);
        newKeyValue.objValue = this.objValue;
        newKeyValue.jsonValue = this.jsonValue;
        return newKeyValue;
    }

    @Override
    public String asJsonString() {
        return Json.toJsonString(this.asReader(), JsonOptions.WITH_TAGS);
    }

    @Override
    public String asJsonString(JsonOptions options) {
        return Json.toJsonString(this.asReader(), options);
    }

    public String toString() {
        return this.asJsonString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return this.valueType == Value.Type.NULL;
        }
        if (obj instanceof JsonValue) {
            JsonValue value = (JsonValue)obj;
            if (this.valueType != value.getType()) {
                return false;
            }
            switch (this.valueType) {
                case BOOLEAN: 
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case TIME: 
                case TIMESTAMP: 
                case DATE: 
                case INTERVAL: {
                    return this.jsonValue == value.jsonValue;
                }
                case NULL: {
                    return this.objValue == null && value.objValue == null;
                }
                case BINARY: 
                case DECIMAL: 
                case STRING: 
                case MAP: 
                case ARRAY: {
                    return this.objValue.equals(value.objValue);
                }
            }
        } else {
            if (obj instanceof String) {
                return this.objValue.equals(obj);
            }
            if (obj instanceof Byte) {
                return obj.equals(this.getByte());
            }
            if (obj instanceof Short) {
                return obj.equals(this.getShort());
            }
            if (obj instanceof Boolean) {
                return obj.equals(this.getBoolean());
            }
            if (obj instanceof Float) {
                return obj.equals(Float.valueOf(this.getFloat()));
            }
            if (obj instanceof Integer) {
                return obj.equals(this.getInt());
            }
            if (obj instanceof Long) {
                return obj.equals(this.getLong());
            }
            if (obj instanceof BigDecimal) {
                return obj.equals(this.getDecimal());
            }
            if (obj instanceof Double) {
                return obj.equals(this.getDouble());
            }
            if (obj instanceof ODate) {
                long dateAsLong = ((ODate)obj).toDaysSinceEpoch();
                return dateAsLong == this.jsonValue;
            }
            if (obj instanceof OTime) {
                long timeAsLong = ((OTime)obj).toTimeInMillis();
                return timeAsLong == this.jsonValue;
            }
            if (obj instanceof OTimestamp) {
                long timestampAsLong = ((OTimestamp)obj).getMillis();
                return this.getTimestampAsLong() == timestampAsLong;
            }
            if (obj instanceof OInterval) {
                return obj.equals(this.getInterval());
            }
            if (obj instanceof ByteBuffer) {
                return obj.equals(this.getBinary());
            }
            if (obj instanceof Map) {
                return this.objValue.equals(obj);
            }
            if (obj instanceof List) {
                return this.objValue.equals(obj);
            }
            if (obj instanceof Value) {
                return this.equals(((Value)obj).getObject());
            }
        }
        return false;
    }
}

