/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.dialect;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.config.NullCollation;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSetOperator;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.SqlUserDefinedTypeNameSpec;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.SqlTypeUtil;

public class BigQuerySqlDialect
extends SqlDialect {
    public static final SqlDialect.Context DEFAULT_CONTEXT = SqlDialect.EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.BIG_QUERY).withLiteralQuoteString("'").withLiteralEscapedQuoteString("\\'").withIdentifierQuoteString("`").withNullCollation(NullCollation.LOW).withUnquotedCasing(Casing.UNCHANGED).withQuotedCasing(Casing.UNCHANGED).withCaseSensitive(false);
    public static final SqlDialect DEFAULT = new BigQuerySqlDialect(DEFAULT_CONTEXT);
    private static final List<String> RESERVED_KEYWORDS = ImmutableList.copyOf(Arrays.asList("ALL", "AND", "ANY", "ARRAY", "AS", "ASC", "ASSERT_ROWS_MODIFIED", "AT", "BETWEEN", "BY", "CASE", "CAST", "COLLATE", "CONTAINS", "CREATE", "CROSS", "CUBE", "CURRENT", "DEFAULT", "DEFINE", "DESC", "DISTINCT", "ELSE", "END", "ENUM", "ESCAPE", "EXCEPT", "EXCLUDE", "EXISTS", "EXTRACT", "FALSE", "FETCH", "FOLLOWING", "FOR", "FROM", "FULL", "GROUP", "GROUPING", "GROUPS", "HASH", "HAVING", "IF", "IGNORE", "IN", "INNER", "INTERSECT", "INTERVAL", "INTO", "IS", "JOIN", "LATERAL", "LEFT", "LIKE", "LIMIT", "LOOKUP", "MERGE", "NATURAL", "NEW", "NO", "NOT", "NULL", "NULLS", "OF", "ON", "OR", "ORDER", "OUTER", "OVER", "PARTITION", "PRECEDING", "PROTO", "RANGE", "RECURSIVE", "RESPECT", "RIGHT", "ROLLUP", "ROWS", "SELECT", "SET", "SOME", "STRUCT", "TABLESAMPLE", "THEN", "TO", "TREAT", "TRUE", "UNBOUNDED", "UNION", "UNNEST", "USING", "WHEN", "WHERE", "WINDOW", "WITH", "WITHIN"));
    private static final Pattern IDENTIFIER_REGEX = Pattern.compile("[A-Za-z][A-Za-z0-9_]*");
    private static final SqlOperator UNION_DISTINCT = new SqlSetOperator("UNION DISTINCT", SqlKind.UNION, 14, false);
    private static final SqlSetOperator EXCEPT_DISTINCT = new SqlSetOperator("EXCEPT DISTINCT", SqlKind.EXCEPT, 14, false);
    private static final SqlSetOperator INTERSECT_DISTINCT = new SqlSetOperator("INTERSECT DISTINCT", SqlKind.INTERSECT, 18, false);

    public BigQuerySqlDialect(SqlDialect.Context context) {
        super(context);
    }

    @Override
    public String quoteIdentifier(String val) {
        return this.quoteIdentifier(new StringBuilder(), val).toString();
    }

    @Override
    protected boolean identifierNeedsQuote(String val) {
        return !IDENTIFIER_REGEX.matcher(val).matches() || RESERVED_KEYWORDS.contains(val.toUpperCase(Locale.ROOT));
    }

    @Override
    public SqlNode emulateNullDirection(SqlNode node, boolean nullsFirst, boolean desc) {
        return this.emulateNullDirectionWithIsNull(node, nullsFirst, desc);
    }

    @Override
    public boolean supportsImplicitTypeCoercion(RexCall call) {
        return super.supportsImplicitTypeCoercion(call) && RexUtil.isLiteral(call.getOperands().get(0), false) && !SqlTypeUtil.isNumeric(call.type);
    }

    @Override
    public void unparseOffsetFetch(SqlWriter writer, SqlNode offset, SqlNode fetch) {
        this.unparseFetchUsingLimit(writer, offset, fetch);
    }

    @Override
    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        switch (call.getKind()) {
            case POSITION: {
                SqlWriter.Frame frame = writer.startFunCall("STRPOS");
                writer.sep(",");
                ((SqlNode)call.operand(1)).unparse(writer, leftPrec, rightPrec);
                writer.sep(",");
                ((SqlNode)call.operand(0)).unparse(writer, leftPrec, rightPrec);
                if (3 == call.operandCount()) {
                    throw new RuntimeException("3rd operand Not Supported for Function STRPOS in Big Query");
                }
                writer.endFunCall(frame);
                break;
            }
            case UNION: {
                if (((SqlSetOperator)call.getOperator()).isAll()) break;
                SqlSyntax.BINARY.unparse(writer, UNION_DISTINCT, call, leftPrec, rightPrec);
                break;
            }
            case EXCEPT: {
                if (((SqlSetOperator)call.getOperator()).isAll()) break;
                SqlSyntax.BINARY.unparse(writer, EXCEPT_DISTINCT, call, leftPrec, rightPrec);
                break;
            }
            case INTERSECT: {
                if (((SqlSetOperator)call.getOperator()).isAll()) break;
                SqlSyntax.BINARY.unparse(writer, INTERSECT_DISTINCT, call, leftPrec, rightPrec);
                break;
            }
            default: {
                super.unparseCall(writer, call, leftPrec, rightPrec);
            }
        }
    }

    @Override
    public SqlNode getCastSpec(RelDataType type) {
        if (type instanceof BasicSqlType) {
            switch (type.getSqlTypeName()) {
                case BIGINT: {
                    return this.createSqlDataTypeSpecByName("INT64");
                }
                case DOUBLE: {
                    return this.createSqlDataTypeSpecByName("FLOAT64");
                }
                case DECIMAL: {
                    return this.createSqlDataTypeSpecByName("NUMERIC");
                }
                case BOOLEAN: {
                    return this.createSqlDataTypeSpecByName("BOOL");
                }
                case VARCHAR: {
                    return this.createSqlDataTypeSpecByName("STRING");
                }
                case VARBINARY: {
                    return this.createSqlDataTypeSpecByName("BYTES");
                }
                case DATE: {
                    return this.createSqlDataTypeSpecByName("DATE");
                }
                case TIME: {
                    return this.createSqlDataTypeSpecByName("TIME");
                }
                case TIMESTAMP: {
                    return this.createSqlDataTypeSpecByName("TIMESTAMP");
                }
            }
        }
        return super.getCastSpec(type);
    }

    private SqlDataTypeSpec createSqlDataTypeSpecByName(String identifierName) {
        SqlUserDefinedTypeNameSpec typeNameSpec = new SqlUserDefinedTypeNameSpec(new SqlIdentifier(identifierName, SqlParserPos.ZERO), SqlParserPos.ZERO);
        return new SqlDataTypeSpec(typeNameSpec, SqlParserPos.ZERO);
    }
}

