/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableIntList;

public class SemiJoinJoinTransposeRule
extends RelOptRule {
    public static final SemiJoinJoinTransposeRule INSTANCE = new SemiJoinJoinTransposeRule(RelFactories.LOGICAL_BUILDER);

    public SemiJoinJoinTransposeRule(RelBuilderFactory relBuilderFactory) {
        super(SemiJoinJoinTransposeRule.operandJ(LogicalJoin.class, null, Join::isSemiJoin, SemiJoinJoinTransposeRule.some(SemiJoinJoinTransposeRule.operand(Join.class, SemiJoinJoinTransposeRule.any()), new RelOptRuleOperand[0])), relBuilderFactory, null);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RelNode rightJoinRel;
        RelNode leftJoinRel;
        RexNode newSemiJoinFilter;
        int i;
        LogicalJoin semiJoin = (LogicalJoin)call.rel(0);
        Join join = (Join)call.rel(1);
        if (join.isSemiJoin()) {
            return;
        }
        ImmutableIntList leftKeys = semiJoin.analyzeCondition().leftKeys;
        int nFieldsX = join.getLeft().getRowType().getFieldList().size();
        int nFieldsY = join.getRight().getRowType().getFieldList().size();
        int nFieldsZ = semiJoin.getRight().getRowType().getFieldList().size();
        int nTotalFields = nFieldsX + nFieldsY + nFieldsZ;
        ArrayList<RelDataTypeField> fields = new ArrayList<RelDataTypeField>();
        List<RelDataTypeField> joinFields = semiJoin.getRowType().getFieldList();
        for (i = 0; i < nFieldsX + nFieldsY; ++i) {
            fields.add(joinFields.get(i));
        }
        joinFields = semiJoin.getRight().getRowType().getFieldList();
        for (i = 0; i < nFieldsZ; ++i) {
            fields.add(joinFields.get(i));
        }
        int nKeysFromX = 0;
        for (int leftKey : leftKeys) {
            if (leftKey >= nFieldsX) continue;
            ++nKeysFromX;
        }
        assert (nKeysFromX == 0 || nKeysFromX == leftKeys.size());
        int[] adjustments = new int[nTotalFields];
        if (nKeysFromX > 0) {
            this.setJoinAdjustments(adjustments, nFieldsX, nFieldsY, nFieldsZ, 0, -nFieldsY);
            newSemiJoinFilter = semiJoin.getCondition().accept(new RelOptUtil.RexInputConverter(semiJoin.getCluster().getRexBuilder(), fields, adjustments));
        } else {
            this.setJoinAdjustments(adjustments, nFieldsX, nFieldsY, nFieldsZ, -nFieldsX, -nFieldsX);
            newSemiJoinFilter = semiJoin.getCondition().accept(new RelOptUtil.RexInputConverter(semiJoin.getCluster().getRexBuilder(), fields, adjustments));
        }
        RelNode leftSemiJoinOp = nKeysFromX > 0 ? join.getLeft() : join.getRight();
        LogicalJoin newSemiJoin = LogicalJoin.create(leftSemiJoinOp, semiJoin.getRight(), newSemiJoinFilter, (Set<CorrelationId>)ImmutableSet.of(), JoinRelType.SEMI);
        if (nKeysFromX > 0) {
            leftJoinRel = newSemiJoin;
            rightJoinRel = join.getRight();
        } else {
            leftJoinRel = join.getLeft();
            rightJoinRel = newSemiJoin;
        }
        Join newJoinRel = join.copy(join.getTraitSet(), join.getCondition(), leftJoinRel, rightJoinRel, join.getJoinType(), join.isSemiJoinDone());
        call.transformTo(newJoinRel);
    }

    private void setJoinAdjustments(int[] adjustments, int nFieldsX, int nFieldsY, int nFieldsZ, int adjustY, int adjustZ) {
        int i;
        for (i = 0; i < nFieldsX; ++i) {
            adjustments[i] = 0;
        }
        for (i = nFieldsX; i < nFieldsX + nFieldsY; ++i) {
            adjustments[i] = adjustY;
        }
        for (i = nFieldsX + nFieldsY; i < nFieldsX + nFieldsY + nFieldsZ; ++i) {
            adjustments[i] = adjustZ;
        }
    }
}

