/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.tools.RelBuilderFactory;

public class SemiJoinFilterTransposeRule
extends RelOptRule {
    public static final SemiJoinFilterTransposeRule INSTANCE = new SemiJoinFilterTransposeRule(RelFactories.LOGICAL_BUILDER);

    public SemiJoinFilterTransposeRule(RelBuilderFactory relBuilderFactory) {
        super(SemiJoinFilterTransposeRule.operandJ(LogicalJoin.class, null, Join::isSemiJoin, SemiJoinFilterTransposeRule.some(SemiJoinFilterTransposeRule.operand(LogicalFilter.class, SemiJoinFilterTransposeRule.any()), new RelOptRuleOperand[0])), relBuilderFactory, null);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        LogicalJoin semiJoin = (LogicalJoin)call.rel(0);
        LogicalFilter filter = (LogicalFilter)call.rel(1);
        LogicalJoin newSemiJoin = LogicalJoin.create(filter.getInput(), semiJoin.getRight(), semiJoin.getCondition(), (Set<CorrelationId>)ImmutableSet.of(), JoinRelType.SEMI);
        RelFactories.FilterFactory factory = RelFactories.DEFAULT_FILTER_FACTORY;
        RelNode newFilter = factory.createFilter(newSemiJoin, filter.getCondition(), (Set<CorrelationId>)ImmutableSet.of());
        call.transformTo(newFilter);
    }
}

