/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.util;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mockit.internal.state.ParameterNames;

public final class MethodFormatter {
    @Nonnull
    private final StringBuilder out = new StringBuilder();
    @Nonnull
    private final List<String> parameterTypes = new ArrayList<String>(5);
    @Nonnull
    private final String classDesc;
    @Nonnull
    private String methodDesc;
    private int parameterIndex;
    private int typeDescPos;
    private char typeCode;
    private int arrayDimensions;

    public MethodFormatter(@Nonnull String classDesc, @Nonnull String methodNameAndDesc) {
        this(classDesc, methodNameAndDesc, true);
    }

    public MethodFormatter(@Nonnull String classDesc, @Nonnull String methodNameAndDesc, boolean withParametersAppended) {
        this.classDesc = classDesc;
        this.methodDesc = "";
        this.methodDesc = methodNameAndDesc;
        this.appendFriendlyMethodSignature(withParametersAppended);
    }

    public String toString() {
        return this.out.toString();
    }

    @Nonnull
    public List<String> getParameterTypes() {
        return this.parameterTypes;
    }

    private void appendFriendlyMethodSignature(boolean withParametersAppended) {
        String className = this.classDesc.replace('/', '.');
        this.out.append(className).append('#');
        String constructorName = MethodFormatter.getConstructorName(className);
        String friendlyDesc = this.methodDesc.replace("<init>", constructorName);
        int leftParenNextPos = friendlyDesc.indexOf(40) + 1;
        int rightParenPos = friendlyDesc.indexOf(41);
        if (leftParenNextPos < rightParenPos) {
            this.out.append(friendlyDesc, 0, leftParenNextPos);
            String concatenatedParameterTypes = friendlyDesc.substring(leftParenNextPos, rightParenPos);
            if (withParametersAppended) {
                this.parameterIndex = 0;
                this.appendParameterTypesAndNames(concatenatedParameterTypes);
                this.out.append(')');
            } else {
                this.addParameterTypes(concatenatedParameterTypes);
            }
        } else {
            this.out.append(friendlyDesc, 0, rightParenPos + 1);
        }
    }

    @Nonnull
    private static String getConstructorName(@Nonnull String className) {
        int p = className.lastIndexOf(46);
        String constructorName = p < 0 ? className : className.substring(p + 1);
        p = constructorName.lastIndexOf(36);
        if (p > 0) {
            constructorName = constructorName.substring(p + 1);
        }
        return constructorName;
    }

    private void appendParameterTypesAndNames(@Nonnull String typeDescs) {
        String sep = "";
        for (String typeDesc : typeDescs.split(";")) {
            this.out.append(sep);
            if (typeDesc.charAt(0) == 'L') {
                this.appendParameterType(MethodFormatter.friendlyReferenceType(typeDesc));
                this.appendParameterName();
            } else {
                this.appendPrimitiveParameterTypesAndNames(typeDesc);
            }
            sep = ", ";
        }
    }

    @Nonnull
    private static String friendlyReferenceType(@Nonnull String typeDesc) {
        return typeDesc.substring(1).replace("java/lang/", "").replace('/', '.');
    }

    private void appendParameterType(@Nonnull String friendlyTypeDesc) {
        this.out.append(friendlyTypeDesc);
        this.parameterTypes.add(friendlyTypeDesc);
    }

    private void appendParameterName() {
        String name = ParameterNames.getName(this.classDesc, this.methodDesc, this.parameterIndex);
        if (name != null) {
            this.out.append(' ').append(name);
        }
        ++this.parameterIndex;
    }

    private void appendPrimitiveParameterTypesAndNames(@Nonnull String typeDesc) {
        String sep = "";
        this.typeDescPos = 0;
        while (this.typeDescPos < typeDesc.length()) {
            this.typeCode = typeDesc.charAt(this.typeDescPos);
            this.advancePastArrayDimensionsIfAny(typeDesc);
            this.out.append(sep);
            String paramType = this.getTypeNameForTypeDesc(typeDesc) + this.getArrayBrackets();
            this.appendParameterType(paramType);
            this.appendParameterName();
            sep = ", ";
            ++this.typeDescPos;
        }
    }

    private void addParameterTypes(@Nonnull String typeDescs) {
        for (String typeDesc : typeDescs.split(";")) {
            if (typeDesc.charAt(0) == 'L') {
                this.parameterTypes.add(MethodFormatter.friendlyReferenceType(typeDesc));
                continue;
            }
            this.addPrimitiveParameterTypes(typeDesc);
        }
    }

    private void addPrimitiveParameterTypes(@Nonnull String typeDesc) {
        this.typeDescPos = 0;
        while (this.typeDescPos < typeDesc.length()) {
            this.typeCode = typeDesc.charAt(this.typeDescPos);
            this.advancePastArrayDimensionsIfAny(typeDesc);
            String paramType = this.getTypeNameForTypeDesc(typeDesc) + this.getArrayBrackets();
            this.parameterTypes.add(paramType);
            ++this.typeDescPos;
        }
    }

    @Nonnull
    private String getTypeNameForTypeDesc(@Nonnull String typeDesc) {
        String paramType;
        switch (this.typeCode) {
            case 'B': {
                return "byte";
            }
            case 'C': {
                return "char";
            }
            case 'D': {
                return "double";
            }
            case 'F': {
                return "float";
            }
            case 'I': {
                return "int";
            }
            case 'J': {
                return "long";
            }
            case 'S': {
                return "short";
            }
            case 'V': {
                return "void";
            }
            case 'Z': {
                return "boolean";
            }
            case 'L': {
                paramType = MethodFormatter.friendlyReferenceType(typeDesc.substring(this.typeDescPos));
                this.typeDescPos = typeDesc.length();
                break;
            }
            default: {
                paramType = typeDesc.substring(this.typeDescPos);
                this.typeDescPos = typeDesc.length();
            }
        }
        return paramType;
    }

    private void advancePastArrayDimensionsIfAny(@Nonnull String param) {
        this.arrayDimensions = 0;
        while (this.typeCode == '[') {
            ++this.typeDescPos;
            this.typeCode = param.charAt(this.typeDescPos);
            ++this.arrayDimensions;
        }
    }

    @Nonnull
    private String getArrayBrackets() {
        String result = "";
        for (int i = 0; i < this.arrayDimensions; ++i) {
            result = result + "[]";
        }
        return result;
    }

    public void append(@Nonnull String text) {
        this.out.append(text);
    }
}

