/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.transformation;

import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.classes.ClassReader;
import mockit.asm.classes.ClassVisitor;
import mockit.asm.classes.ClassWriter;
import mockit.asm.classes.WrappingClassVisitor;
import mockit.asm.methods.MethodVisitor;
import mockit.asm.methods.MethodWriter;
import mockit.internal.expectations.transformation.InvocationBlockModifier;
import mockit.internal.util.ClassNaming;
import mockit.internal.util.VisitInterruptedException;

public final class ExpectationsTransformer
implements ClassFileTransformer {
    private static final String BASE_CLASSES = "mockit/Expectations mockit/Verifications mockit/VerificationsInOrder mockit/FullVerifications";

    @Override
    @Nullable
    public byte[] transform(@Nullable ClassLoader loader, @Nonnull String className, @Nullable Class<?> classBeingRedefined, @Nullable ProtectionDomain protectionDomain, @Nonnull byte[] classfileBuffer) {
        boolean anonymousClass;
        if (classBeingRedefined == null && protectionDomain != null && (anonymousClass = ClassNaming.isAnonymousClass(className)) && !ExpectationsTransformer.isJMockitClass(className) && !className.startsWith("org/junit/")) {
            ClassReader cr = new ClassReader(classfileBuffer);
            String superClassName = cr.getSuperName();
            if (!BASE_CLASSES.contains(superClassName)) {
                return null;
            }
            return ExpectationsTransformer.modifyInvocationsSubclass(cr, className);
        }
        return null;
    }

    private static boolean isJMockitClass(@Nonnull String classDesc) {
        return classDesc.startsWith("mockit/") && (classDesc.startsWith("mockit/internal/") || classDesc.startsWith("mockit/coverage/") || classDesc.startsWith("mockit/integration/"));
    }

    @Nullable
    private static byte[] modifyInvocationsSubclass(@Nonnull ClassReader cr, final @Nonnull String classDesc) {
        ClassWriter cw = new ClassWriter(cr);
        WrappingClassVisitor modifier = new WrappingClassVisitor(cw){

            @Override
            public MethodVisitor visitMethod(int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nullable String[] exceptions) {
                MethodWriter mw = this.cw.visitMethod(access, name, desc, signature, exceptions);
                if (!"<init>".equals(name)) {
                    return mw;
                }
                return new InvocationBlockModifier(mw, classDesc);
            }
        };
        try {
            cr.accept(modifier);
            return ((ClassVisitor)modifier).toByteArray();
        }
        catch (VisitInterruptedException visitInterruptedException) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }
}

