/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.annotation.Nonnull;
import mockit.coverage.Configuration;
import mockit.coverage.data.CoverageData;
import mockit.coverage.data.FileCoverageData;
import mockit.coverage.lines.LineCoverageData;
import mockit.coverage.lines.PerFileLineCoverage;

final class XmlFile {
    @Nonnull
    private final String srcDir;
    @Nonnull
    private final File outputFile;
    @Nonnull
    private final CoverageData coverageData;
    private Writer output;

    XmlFile(@Nonnull String outputDir, @Nonnull CoverageData coverageData) {
        String firstSrcDir = Configuration.getProperty("srcDirs", "").split("\\s*,\\s*")[0];
        this.srcDir = firstSrcDir.isEmpty() ? "" : firstSrcDir + '/';
        String parentDir = Configuration.getOrChooseOutputDirectory(outputDir);
        this.outputFile = new File(parentDir, "coverage.xml");
        this.coverageData = coverageData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void generate() throws IOException {
        this.output = new FileWriter(this.outputFile);
        try {
            this.output.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            this.output.write("<coverage version=\"1\">\n");
            for (Map.Entry<String, FileCoverageData> fileAndData : this.coverageData.getFileToFileDataMap().entrySet()) {
                String sourceFileName = fileAndData.getKey();
                this.writeOpeningXmlElementForSourceFile(sourceFileName);
                PerFileLineCoverage lineInfo = fileAndData.getValue().lineCoverageInfo;
                this.writeXmlElementsForExecutableLines(lineInfo);
                this.output.write("\t</file>\n");
            }
            this.output.write("</coverage>\n");
        }
        finally {
            this.output.close();
        }
        System.out.println("JMockit: Coverage data written to " + this.outputFile.getCanonicalPath());
    }

    private void writeOpeningXmlElementForSourceFile(@Nonnull String sourceFileName) throws IOException {
        this.output.write("\t<file path=\"");
        this.output.write(this.srcDir);
        this.output.write(sourceFileName);
        this.output.write("\">\n");
    }

    private void writeXmlElementsForExecutableLines(@Nonnull PerFileLineCoverage lineInfo) throws IOException {
        int lineCount = lineInfo.getLineCount();
        for (int lineNum = 1; lineNum <= lineCount; ++lineNum) {
            if (!lineInfo.hasLineData(lineNum)) continue;
            LineCoverageData lineData = lineInfo.getLineData(lineNum);
            this.output.write("\t\t<lineToCover lineNumber=\"");
            this.writeNumber(lineNum);
            this.output.write("\" covered=\"");
            this.output.write(Boolean.toString(lineData.isCovered()));
            if (lineData.containsBranches()) {
                this.output.write("\" branchesToCover=\"");
                this.writeNumber(lineData.getNumberOfBranchingSourcesAndTargets());
                this.output.write("\" coveredBranches=\"");
                this.writeNumber(lineData.getNumberOfCoveredBranchingSourcesAndTargets());
            }
            this.output.write("\"/>\n");
        }
    }

    private void writeNumber(int value) throws IOException {
        this.output.write(Integer.toString(value));
    }
}

