/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Configuration {
    private static final String COVERAGE_PREFIX = "coverage-";

    private Configuration() {
    }

    @Nullable
    public static String getProperty(@Nonnull String nameSuffix) {
        return Configuration.getProperty(nameSuffix, null);
    }

    public static String getProperty(@Nonnull String nameSuffix, @Nullable String defaultValue) {
        return System.getProperty(COVERAGE_PREFIX + nameSuffix, defaultValue);
    }

    @Nullable
    public static String getOrChooseOutputDirectory(@Nonnull String outputDir) {
        if (!outputDir.isEmpty()) {
            return outputDir;
        }
        String mavenBaseDir = System.getProperty("basedir");
        return mavenBaseDir == null ? null : "target";
    }

    @Nonnull
    public static String getOrChooseOutputDirectory(@Nonnull String outputDir, @Nonnull String defaultDir) {
        if (!outputDir.isEmpty()) {
            return outputDir;
        }
        String mavenBaseDir = System.getProperty("basedir");
        return mavenBaseDir == null ? defaultDir : "target/" + defaultDir;
    }
}

