/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm.exceptionHandling;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.constantPool.ConstantPoolGeneration;
import mockit.asm.controlFlow.Edge;
import mockit.asm.controlFlow.Label;
import mockit.asm.exceptionHandling.ExceptionHandler;
import mockit.asm.util.ByteVector;

public final class ExceptionHandling {
    @Nonnull
    private final ConstantPoolGeneration cp;
    @Nonnegative
    private int handlerCount;
    @Nullable
    private ExceptionHandler firstExceptionHandler;
    @Nullable
    private ExceptionHandler lastExceptionHandler;

    public ExceptionHandling(@Nonnull ConstantPoolGeneration cp) {
        this.cp = cp;
    }

    public void addHandler(@Nonnull Label start, @Nonnull Label end, @Nonnull Label handler, @Nullable String type) {
        ++this.handlerCount;
        int handlerType = type != null ? this.cp.newClass(type) : 0;
        ExceptionHandler h = new ExceptionHandler(start, end, handler, type, handlerType);
        if (this.lastExceptionHandler == null) {
            this.firstExceptionHandler = h;
        } else {
            this.lastExceptionHandler.next = h;
        }
        this.lastExceptionHandler = h;
    }

    public void countNumberOfHandlers() {
        ExceptionHandler exceptionHandler = this.firstExceptionHandler;
        this.handlerCount = 0;
        while (exceptionHandler != null) {
            ++this.handlerCount;
            exceptionHandler = exceptionHandler.next;
        }
    }

    public void completeControlFlowGraphWithExceptionHandlerBlocksFromComputedFrames() {
        ExceptionHandler exceptionHandler = this.firstExceptionHandler;
        while (exceptionHandler != null) {
            Label handler = exceptionHandler.handler.getFirst();
            Label start = exceptionHandler.start.getFirst();
            Label end = exceptionHandler.end.getFirst();
            String catchType = exceptionHandler.getCatchTypeDesc();
            int kindOfEdge = 0x1700000 | this.cp.addNormalType(catchType);
            handler.markAsTarget();
            ExceptionHandling.addHandlerLabelAsSuccessor(kindOfEdge, handler, start, end);
            exceptionHandler = exceptionHandler.next;
        }
    }

    public void completeControlFlowGraphWithExceptionHandlerBlocks() {
        ExceptionHandler exceptionHandler = this.firstExceptionHandler;
        while (exceptionHandler != null) {
            ExceptionHandling.addHandlerLabelAsSuccessor(Integer.MAX_VALUE, exceptionHandler.handler, exceptionHandler.start, exceptionHandler.end);
            exceptionHandler = exceptionHandler.next;
        }
    }

    private static void addHandlerLabelAsSuccessor(int kindOfEdge, @Nonnull Label handler, @Nonnull Label start, @Nonnull Label end) {
        while (start != end) {
            Edge edge = new Edge(kindOfEdge, handler);
            start = start.setSuccessors(edge);
        }
    }

    public void removeStartEndRange(@Nonnull Label start, @Nullable Label end) {
        this.firstExceptionHandler = ExceptionHandler.remove(this.firstExceptionHandler, start, end);
    }

    public boolean hasHandlers() {
        return this.handlerCount > 0;
    }

    @Nonnegative
    public int getSize() {
        return 8 * this.handlerCount;
    }

    public void put(@Nonnull ByteVector out) {
        out.putShort(this.handlerCount);
        if (this.handlerCount > 0) {
            ExceptionHandler h = this.firstExceptionHandler;
            while (h != null) {
                h.put(out);
                h = h.next;
            }
        }
    }
}

