/*
 * Decompiled with CFR 0.152.
 */
package liquibase.report;

import java.util.ArrayList;
import java.util.List;
import liquibase.changelog.ChangeSet;
import liquibase.report.IndividualChangesetInfo;
import liquibase.util.CollectionUtil;
import liquibase.util.StringUtil;

public class ChangesetInfo {
    private int changesetCount;
    private final List<IndividualChangesetInfo> changesetInfoList = new ArrayList<IndividualChangesetInfo>();

    public void addAllToChangesetInfoList(List<ChangeSet> changeSets, boolean isRollback) {
        if (changeSets != null) {
            for (ChangeSet deployedChangeSet : changeSets) {
                String changesetOutcome = isRollback ? (deployedChangeSet.getRollbackExecType() == null ? "" : deployedChangeSet.getRollbackExecType().toString()) : (deployedChangeSet.getExecType() == null ? "" : deployedChangeSet.getExecType().toString());
                String errorMsg = deployedChangeSet.getErrorMsg();
                if (StringUtil.isNotEmpty(errorMsg)) {
                    changesetOutcome = ChangeSet.ExecType.FAILED.value;
                }
                this.changesetInfoList.add(new IndividualChangesetInfo(this.changesetInfoList.size() + 1, deployedChangeSet.getAuthor(), deployedChangeSet.getId(), deployedChangeSet.getFilePath(), deployedChangeSet.getComments(), changesetOutcome, errorMsg, deployedChangeSet.getLabels() == null ? null : deployedChangeSet.getLabels().toString(), deployedChangeSet.getContextFilter() == null ? null : deployedChangeSet.getContextFilter().getOriginalString(), ChangesetInfo.buildAttributesString(deployedChangeSet), deployedChangeSet.getGeneratedSql()));
            }
        }
    }

    private static List<String> buildAttributesString(ChangeSet changeSet) {
        ArrayList<String> attributes = new ArrayList<String>();
        if (changeSet.getFailOnError() != null && !changeSet.getFailOnError().booleanValue()) {
            attributes.add("failOnError = false");
        }
        if (changeSet.isAlwaysRun()) {
            attributes.add("alwaysRun");
        }
        if (changeSet.isRunOnChange()) {
            attributes.add("runOnChange");
        }
        if (!changeSet.isRunInTransaction()) {
            attributes.add("runInTransaction = false");
        }
        if (StringUtil.isNotEmpty(changeSet.getRunOrder())) {
            attributes.add("runOrder = " + changeSet.getRunOrder());
        }
        if (StringUtil.isNotEmpty(changeSet.getRunWith())) {
            attributes.add("runWith = " + changeSet.getRunWith());
        }
        if (StringUtil.isNotEmpty(changeSet.getRunWithSpoolFile())) {
            attributes.add("runWithSpoolFile = " + changeSet.getRunWithSpoolFile());
        }
        if (!CollectionUtil.createIfNull(changeSet.getDbmsSet()).isEmpty()) {
            attributes.add("dbms = " + StringUtil.join(changeSet.getDbmsSet(), ", "));
        }
        return attributes;
    }

    public int getChangesetCount() {
        return this.changesetCount;
    }

    public List<IndividualChangesetInfo> getChangesetInfoList() {
        return this.changesetInfoList;
    }

    public void setChangesetCount(int changesetCount) {
        this.changesetCount = changesetCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangesetInfo)) {
            return false;
        }
        ChangesetInfo other = (ChangesetInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getChangesetCount() != other.getChangesetCount()) {
            return false;
        }
        List<IndividualChangesetInfo> this$changesetInfoList = this.getChangesetInfoList();
        List<IndividualChangesetInfo> other$changesetInfoList = other.getChangesetInfoList();
        return !(this$changesetInfoList == null ? other$changesetInfoList != null : !((Object)this$changesetInfoList).equals(other$changesetInfoList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChangesetInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getChangesetCount();
        List<IndividualChangesetInfo> $changesetInfoList = this.getChangesetInfoList();
        result = result * 59 + ($changesetInfoList == null ? 43 : ((Object)$changesetInfoList).hashCode());
        return result;
    }

    public String toString() {
        return "ChangesetInfo(changesetCount=" + this.getChangesetCount() + ", changesetInfoList=" + this.getChangesetInfoList() + ")";
    }
}

