/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.io.WALLink;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.snapshot.SnapshotReferenceUtil;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Public
@InterfaceStability.Evolving
@Deprecated
public final class SnapshotInfo
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(SnapshotInfo.class);
    private boolean printSizeInBytes = false;
    private FileSystem fs;
    private Path rootDir;
    private SnapshotManifest snapshotManifest;

    @SuppressWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Intentional")
    public int run(String[] args) throws IOException, InterruptedException {
        Configuration conf = this.getConf();
        boolean listSnapshots = false;
        String snapshotName = null;
        boolean showSchema = false;
        boolean showFiles = false;
        boolean showStats = false;
        for (int i = 0; i < args.length; ++i) {
            String cmd = args[i];
            try {
                if (cmd.equals("-snapshot")) {
                    snapshotName = args[++i];
                    continue;
                }
                if (cmd.equals("-files")) {
                    showFiles = true;
                    showStats = true;
                    continue;
                }
                if (cmd.equals("-stats")) {
                    showStats = true;
                    continue;
                }
                if (cmd.equals("-schema")) {
                    showSchema = true;
                    continue;
                }
                if (cmd.equals("-remote-dir")) {
                    Path sourceDir = new Path(args[++i]);
                    URI defaultFs = sourceDir.getFileSystem(conf).getUri();
                    FSUtils.setFsDefault(conf, new Path(defaultFs));
                    FSUtils.setRootDir(conf, sourceDir);
                    continue;
                }
                if (cmd.equals("-list-snapshots")) {
                    listSnapshots = true;
                    continue;
                }
                if (cmd.equals("-size-in-bytes")) {
                    this.printSizeInBytes = true;
                    continue;
                }
                if (cmd.equals("-h") || cmd.equals("--help")) {
                    this.printUsageAndExit();
                    continue;
                }
                System.err.println("UNEXPECTED: " + cmd);
                this.printUsageAndExit();
                continue;
            }
            catch (Exception e) {
                this.printUsageAndExit();
            }
        }
        if (listSnapshots) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            System.out.printf("%-20s | %-20s | %s%n", "SNAPSHOT", "CREATION TIME", "TABLE NAME");
            for (HBaseProtos.SnapshotDescription desc : SnapshotInfo.getSnapshotList(conf)) {
                System.out.printf("%-20s | %20s | %s%n", desc.getName(), df.format(new Date(desc.getCreationTime())), desc.getTable());
            }
            return 0;
        }
        if (snapshotName == null) {
            System.err.println("Missing snapshot name!");
            this.printUsageAndExit();
            return 1;
        }
        this.rootDir = FSUtils.getRootDir(conf);
        this.fs = FileSystem.get((URI)this.rootDir.toUri(), (Configuration)conf);
        LOG.debug((Object)("fs=" + this.fs.getUri().toString() + " root=" + this.rootDir));
        if (!this.loadSnapshotInfo(snapshotName)) {
            System.err.println("Snapshot '" + snapshotName + "' not found!");
            return 1;
        }
        this.printInfo();
        if (showSchema) {
            this.printSchema();
        }
        this.printFiles(showFiles, showStats);
        return 0;
    }

    private boolean loadSnapshotInfo(String snapshotName) throws IOException {
        Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(snapshotName, this.rootDir);
        if (!this.fs.exists(snapshotDir)) {
            LOG.warn((Object)("Snapshot '" + snapshotName + "' not found in: " + snapshotDir));
            return false;
        }
        HBaseProtos.SnapshotDescription snapshotDesc = SnapshotDescriptionUtils.readSnapshotInfo(this.fs, snapshotDir);
        this.snapshotManifest = SnapshotManifest.open(this.getConf(), this.fs, snapshotDir, snapshotDesc);
        return true;
    }

    private void printInfo() {
        HBaseProtos.SnapshotDescription snapshotDesc = this.snapshotManifest.getSnapshotDescription();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        System.out.println("Snapshot Info");
        System.out.println("----------------------------------------");
        System.out.println("   Name: " + snapshotDesc.getName());
        System.out.println("   Type: " + snapshotDesc.getType());
        System.out.println("  Table: " + snapshotDesc.getTable());
        System.out.println(" Format: " + snapshotDesc.getVersion());
        System.out.println("Created: " + df.format(new Date(snapshotDesc.getCreationTime())));
        System.out.println("  Owner: " + snapshotDesc.getOwner());
        System.out.println();
    }

    private void printSchema() {
        System.out.println("Table Descriptor");
        System.out.println("----------------------------------------");
        System.out.println(this.snapshotManifest.getTableDescriptor().toString());
        System.out.println();
    }

    private void printFiles(final boolean showFiles, boolean showStats) throws IOException {
        if (showFiles) {
            System.out.println("Snapshot Files");
            System.out.println("----------------------------------------");
        }
        HBaseProtos.SnapshotDescription snapshotDesc = this.snapshotManifest.getSnapshotDescription();
        final String table = snapshotDesc.getTable();
        final SnapshotStats stats = new SnapshotStats(this.getConf(), this.fs, snapshotDesc);
        SnapshotReferenceUtil.concurrentVisitReferencedFiles(this.getConf(), this.fs, this.snapshotManifest, "SnapshotInfo", (SnapshotReferenceUtil.StoreFileVisitor)new SnapshotReferenceUtil.SnapshotVisitor(){

            @Override
            public void storeFile(HRegionInfo regionInfo, String family, SnapshotProtos.SnapshotRegionManifest.StoreFile storeFile) throws IOException {
                if (storeFile.hasReference()) {
                    return;
                }
                SnapshotStats.FileInfo info = stats.addStoreFile(regionInfo, family, storeFile, null);
                if (showFiles) {
                    String state = info.getStateToString();
                    System.out.printf("%8s %s/%s/%s/%s %s%n", info.isMissing() ? "-" : SnapshotInfo.this.fileSizeToString(info.getSize()), table, regionInfo.getEncodedName(), family, storeFile.getName(), state == null ? "" : "(" + state + ")");
                }
            }
        });
        System.out.println();
        if (stats.isSnapshotCorrupted()) {
            System.out.println("**************************************************************");
            System.out.printf("BAD SNAPSHOT: %d hfile(s) and %d log(s) missing.%n", stats.getMissingStoreFilesCount(), stats.getMissingLogsCount());
            System.out.printf("              %d hfile(s) corrupted.%n", stats.getCorruptedStoreFilesCount());
            System.out.println("**************************************************************");
        }
        if (showStats) {
            System.out.printf("%d HFiles (%d in archive), total size %s (%.2f%% %s shared with the source table)%n", stats.getStoreFilesCount(), stats.getArchivedStoreFilesCount(), this.fileSizeToString(stats.getStoreFilesSize()), Float.valueOf(stats.getSharedStoreFilePercentage()), this.fileSizeToString(stats.getSharedStoreFilesSize()));
            System.out.printf("%d Logs, total size %s%n", stats.getLogsCount(), this.fileSizeToString(stats.getLogsSize()));
            System.out.println();
        }
    }

    private String fileSizeToString(long size) {
        return this.printSizeInBytes ? Long.toString(size) : StringUtils.humanReadableInt((long)size);
    }

    private void printUsageAndExit() {
        System.err.printf("Usage: bin/hbase snapshot info [options]%n", new Object[0]);
        System.err.println(" where [options] are:");
        System.err.println("  -h|-help                Show this help and exit.");
        System.err.println("  -remote-dir             Root directory that contains the snapshots.");
        System.err.println("  -list-snapshots         List all the available snapshots and exit.");
        System.err.println("  -size-in-bytes          Print the size of the files in bytes.");
        System.err.println("  -snapshot NAME          Snapshot to examine.");
        System.err.println("  -files                  Files and logs list.");
        System.err.println("  -stats                  Files and logs stats.");
        System.err.println("  -schema                 Describe the snapshotted table.");
        System.err.println();
        System.err.println("Examples:");
        System.err.println("  hbase snapshot info \\");
        System.err.println("    -snapshot MySnapshot -files");
        System.exit(1);
    }

    public static SnapshotStats getSnapshotStats(Configuration conf, HBaseProtos.SnapshotDescription snapshot) throws IOException {
        return SnapshotInfo.getSnapshotStats(conf, snapshot, null);
    }

    public static SnapshotStats getSnapshotStats(Configuration conf, HBaseProtos.SnapshotDescription snapshot, final Map<Path, Integer> filesMap) throws IOException {
        Path rootDir = FSUtils.getRootDir(conf);
        FileSystem fs = FileSystem.get((URI)rootDir.toUri(), (Configuration)conf);
        Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(snapshot, rootDir);
        SnapshotManifest manifest = SnapshotManifest.open(conf, fs, snapshotDir, snapshot);
        final SnapshotStats stats = new SnapshotStats(conf, fs, snapshot);
        SnapshotReferenceUtil.concurrentVisitReferencedFiles(conf, fs, manifest, "SnapshotsStatsAggregation", (SnapshotReferenceUtil.StoreFileVisitor)new SnapshotReferenceUtil.SnapshotVisitor(){

            @Override
            public void storeFile(HRegionInfo regionInfo, String family, SnapshotProtos.SnapshotRegionManifest.StoreFile storeFile) throws IOException {
                if (!storeFile.hasReference()) {
                    stats.addStoreFile(regionInfo, family, storeFile, filesMap);
                }
            }
        });
        return stats;
    }

    public static List<HBaseProtos.SnapshotDescription> getSnapshotList(Configuration conf) throws IOException {
        Path rootDir = FSUtils.getRootDir(conf);
        FileSystem fs = FileSystem.get((URI)rootDir.toUri(), (Configuration)conf);
        Path snapshotDir = SnapshotDescriptionUtils.getSnapshotsDir(rootDir);
        FileStatus[] snapshots = fs.listStatus(snapshotDir, (PathFilter)new SnapshotDescriptionUtils.CompletedSnaphotDirectoriesFilter(fs));
        ArrayList<HBaseProtos.SnapshotDescription> snapshotLists = new ArrayList<HBaseProtos.SnapshotDescription>(snapshots.length);
        for (FileStatus snapshotDirStat : snapshots) {
            snapshotLists.add(SnapshotDescriptionUtils.readSnapshotInfo(fs, snapshotDirStat.getPath()));
        }
        return snapshotLists;
    }

    private static void getSnapshotFilesMap(final Configuration conf, final HBaseProtos.SnapshotDescription snapshot, ExecutorService exec, final ConcurrentHashMap<Path, Integer> filesMap, final AtomicLong uniqueHFilesArchiveSize, final AtomicLong uniqueHFilesSize) throws IOException {
        Path rootDir = FSUtils.getRootDir(conf);
        final FileSystem fs = FileSystem.get((URI)rootDir.toUri(), (Configuration)conf);
        Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(snapshot, rootDir);
        SnapshotManifest manifest = SnapshotManifest.open(conf, fs, snapshotDir, snapshot);
        SnapshotReferenceUtil.concurrentVisitReferencedFiles(conf, fs, manifest, exec, (SnapshotReferenceUtil.StoreFileVisitor)new SnapshotReferenceUtil.SnapshotVisitor(){

            @Override
            public void storeFile(HRegionInfo regionInfo, String family, SnapshotProtos.SnapshotRegionManifest.StoreFile storeFile) throws IOException {
                if (!storeFile.hasReference()) {
                    long size;
                    AtomicLong al;
                    Path p;
                    HFileLink link = HFileLink.build(conf, TableName.valueOf((String)snapshot.getTable()), regionInfo.getEncodedName(), family, storeFile.getName());
                    int c = 0;
                    if (fs.exists(link.getArchivePath())) {
                        p = link.getArchivePath();
                        al = uniqueHFilesArchiveSize;
                        size = fs.getFileStatus(p).getLen();
                    } else {
                        p = link.getOriginPath();
                        al = uniqueHFilesSize;
                        size = link.getFileStatus(fs).getLen();
                    }
                    Integer count = (Integer)filesMap.get(p);
                    if (count != null) {
                        c = count;
                    } else {
                        al.addAndGet(size);
                    }
                    filesMap.put(p, ++c);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Path, Integer> getSnapshotsFilesMap(Configuration conf, AtomicLong uniqueHFilesArchiveSize, AtomicLong uniqueHFilesSize) throws IOException {
        List<HBaseProtos.SnapshotDescription> snapshotList = SnapshotInfo.getSnapshotList(conf);
        if (snapshotList.size() == 0) {
            return Collections.emptyMap();
        }
        ConcurrentHashMap<Path, Integer> fileMap = new ConcurrentHashMap<Path, Integer>();
        ThreadPoolExecutor exec = SnapshotManifest.createExecutor(conf, "SnapshotsFilesMapping");
        try {
            for (HBaseProtos.SnapshotDescription snapshot : snapshotList) {
                SnapshotInfo.getSnapshotFilesMap(conf, snapshot, exec, fileMap, uniqueHFilesArchiveSize, uniqueHFilesSize);
            }
        }
        finally {
            exec.shutdown();
        }
        return fileMap;
    }

    static int innerMain(String[] args) throws Exception {
        return ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)new SnapshotInfo(), (String[])args);
    }

    public static void main(String[] args) throws Exception {
        System.exit(SnapshotInfo.innerMain(args));
    }

    public static class SnapshotStats {
        private AtomicInteger hfileArchiveCount = new AtomicInteger();
        private AtomicInteger hfilesCorrupted = new AtomicInteger();
        private AtomicInteger hfilesMissing = new AtomicInteger();
        private AtomicInteger hfilesCount = new AtomicInteger();
        private AtomicInteger logsMissing = new AtomicInteger();
        private AtomicInteger logsCount = new AtomicInteger();
        private AtomicLong hfileArchiveSize = new AtomicLong();
        private AtomicLong hfileSize = new AtomicLong();
        private AtomicLong nonSharedHfilesArchiveSize = new AtomicLong();
        private AtomicLong logSize = new AtomicLong();
        private final HBaseProtos.SnapshotDescription snapshot;
        private final TableName snapshotTable;
        private final Configuration conf;
        private final FileSystem fs;

        SnapshotStats(Configuration conf, FileSystem fs, HBaseProtos.SnapshotDescription snapshot) {
            this.snapshot = snapshot;
            this.snapshotTable = TableName.valueOf((String)snapshot.getTable());
            this.conf = conf;
            this.fs = fs;
        }

        public HBaseProtos.SnapshotDescription getSnapshotDescription() {
            return this.snapshot;
        }

        public boolean isSnapshotCorrupted() {
            return this.hfilesMissing.get() > 0 || this.logsMissing.get() > 0 || this.hfilesCorrupted.get() > 0;
        }

        public int getStoreFilesCount() {
            return this.hfilesCount.get() + this.hfileArchiveCount.get();
        }

        public int getArchivedStoreFilesCount() {
            return this.hfileArchiveCount.get();
        }

        public int getLogsCount() {
            return this.logsCount.get();
        }

        public int getMissingStoreFilesCount() {
            return this.hfilesMissing.get();
        }

        public int getCorruptedStoreFilesCount() {
            return this.hfilesCorrupted.get();
        }

        public int getMissingLogsCount() {
            return this.logsMissing.get();
        }

        public long getStoreFilesSize() {
            return this.hfileSize.get() + this.hfileArchiveSize.get();
        }

        public long getSharedStoreFilesSize() {
            return this.hfileSize.get();
        }

        public long getArchivedStoreFileSize() {
            return this.hfileArchiveSize.get();
        }

        public long getNonSharedArchivedStoreFilesSize() {
            return this.nonSharedHfilesArchiveSize.get();
        }

        public float getSharedStoreFilePercentage() {
            return (float)this.hfileSize.get() / (float)(this.hfileSize.get() + this.hfileArchiveSize.get()) * 100.0f;
        }

        public long getLogsSize() {
            return this.logSize.get();
        }

        private boolean isArchivedFileStillReferenced(Path filePath, Map<Path, Integer> snapshotFilesMap) {
            Integer c = snapshotFilesMap.get(filePath);
            if (c != null && c == 1) {
                Path parentDir = filePath.getParent();
                Path backRefDir = HFileLink.getBackReferencesDir(parentDir, filePath.getName());
                try {
                    if (FSUtils.listStatus(this.fs, backRefDir) == null) {
                        return false;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return true;
        }

        FileInfo addStoreFile(HRegionInfo region, String family, SnapshotProtos.SnapshotRegionManifest.StoreFile storeFile, Map<Path, Integer> filesMap) throws IOException {
            HFileLink link = HFileLink.build(this.conf, this.snapshotTable, region.getEncodedName(), family, storeFile.getName());
            boolean isCorrupted = false;
            boolean inArchive = false;
            long size = -1L;
            try {
                inArchive = this.fs.exists(link.getArchivePath());
                if (inArchive) {
                    size = this.fs.getFileStatus(link.getArchivePath()).getLen();
                    this.hfileArchiveSize.addAndGet(size);
                    this.hfileArchiveCount.incrementAndGet();
                    if (filesMap != null && !this.isArchivedFileStillReferenced(link.getArchivePath(), filesMap)) {
                        this.nonSharedHfilesArchiveSize.addAndGet(size);
                    }
                } else {
                    size = link.getFileStatus(this.fs).getLen();
                    this.hfileSize.addAndGet(size);
                    this.hfilesCount.incrementAndGet();
                }
                boolean bl = isCorrupted = storeFile.hasFileSize() && storeFile.getFileSize() != size;
                if (isCorrupted) {
                    this.hfilesCorrupted.incrementAndGet();
                }
            }
            catch (FileNotFoundException e) {
                this.hfilesMissing.incrementAndGet();
            }
            return new FileInfo(inArchive, size, isCorrupted);
        }

        FileInfo addLogFile(String server, String logfile) throws IOException {
            WALLink logLink = new WALLink(this.conf, server, logfile);
            long size = -1L;
            try {
                size = logLink.getFileStatus(this.fs).getLen();
                this.logSize.addAndGet(size);
                this.logsCount.incrementAndGet();
            }
            catch (FileNotFoundException e) {
                this.logsMissing.incrementAndGet();
            }
            return new FileInfo(false, size, false);
        }

        static class FileInfo {
            private final boolean corrupted;
            private final boolean inArchive;
            private final long size;

            FileInfo(boolean inArchive, long size, boolean corrupted) {
                this.corrupted = corrupted;
                this.inArchive = inArchive;
                this.size = size;
            }

            public boolean inArchive() {
                return this.inArchive;
            }

            public boolean isCorrupted() {
                return this.corrupted;
            }

            public boolean isMissing() {
                return this.size < 0L;
            }

            public long getSize() {
                return this.size;
            }

            String getStateToString() {
                if (this.isCorrupted()) {
                    return "CORRUPTED";
                }
                if (this.isMissing()) {
                    return "NOT FOUND";
                }
                if (this.inArchive()) {
                    return "archive";
                }
                return null;
            }
        }
    }
}

