/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.ddl;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.runtime.Resources;
import org.apache.calcite.sql.SqlDrop;
import org.apache.calcite.sql.SqlExecutableStatement;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.Static;

public class SqlDropSchema
extends SqlDrop
implements SqlExecutableStatement {
    private final boolean foreign;
    private final SqlIdentifier name;
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("DROP SCHEMA", SqlKind.DROP_TABLE);

    SqlDropSchema(SqlParserPos pos, boolean foreign, boolean ifExists, SqlIdentifier name) {
        super(OPERATOR, pos, ifExists);
        this.foreign = foreign;
        this.name = name;
    }

    public List<SqlNode> getOperandList() {
        return ImmutableList.of((Object)SqlLiteral.createBoolean((boolean)this.foreign, (SqlParserPos)SqlParserPos.ZERO), (Object)this.name);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("DROP");
        if (this.foreign) {
            writer.keyword("FOREIGN");
        }
        writer.keyword("SCHEMA");
        if (this.ifExists) {
            writer.keyword("IF EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
    }

    public void execute(CalcitePrepare.Context context) {
        List path = context.getDefaultSchemaPath();
        CalciteSchema schema = context.getRootSchema();
        for (String p : path) {
            schema = schema.getSubSchema(p, true);
        }
        boolean existed = schema.removeSubSchema(this.name.getSimple());
        if (!existed && !this.ifExists) {
            throw SqlUtil.newContextException((SqlParserPos)this.name.getParserPosition(), (Resources.ExInst)Static.RESOURCE.schemaNotFound(this.name.getSimple()));
        }
    }
}

