/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.objectstorage.ObjectStorage;
import com.oracle.bmc.objectstorage.model.BucketSummary;
import com.oracle.bmc.objectstorage.model.MultipartUpload;
import com.oracle.bmc.objectstorage.model.MultipartUploadPartSummary;
import com.oracle.bmc.objectstorage.model.ObjectSummary;
import com.oracle.bmc.objectstorage.model.ObjectVersionSummary;
import com.oracle.bmc.objectstorage.model.PreauthenticatedRequestSummary;
import com.oracle.bmc.objectstorage.model.ReplicationPolicySummary;
import com.oracle.bmc.objectstorage.model.ReplicationSource;
import com.oracle.bmc.objectstorage.model.RetentionRuleSummary;
import com.oracle.bmc.objectstorage.model.WorkRequestError;
import com.oracle.bmc.objectstorage.model.WorkRequestLogEntry;
import com.oracle.bmc.objectstorage.model.WorkRequestSummary;
import com.oracle.bmc.objectstorage.requests.ListBucketsRequest;
import com.oracle.bmc.objectstorage.requests.ListMultipartUploadPartsRequest;
import com.oracle.bmc.objectstorage.requests.ListMultipartUploadsRequest;
import com.oracle.bmc.objectstorage.requests.ListObjectVersionsRequest;
import com.oracle.bmc.objectstorage.requests.ListObjectsRequest;
import com.oracle.bmc.objectstorage.requests.ListPreauthenticatedRequestsRequest;
import com.oracle.bmc.objectstorage.requests.ListReplicationPoliciesRequest;
import com.oracle.bmc.objectstorage.requests.ListReplicationSourcesRequest;
import com.oracle.bmc.objectstorage.requests.ListRetentionRulesRequest;
import com.oracle.bmc.objectstorage.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.objectstorage.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.objectstorage.requests.ListWorkRequestsRequest;
import com.oracle.bmc.objectstorage.responses.ListBucketsResponse;
import com.oracle.bmc.objectstorage.responses.ListMultipartUploadPartsResponse;
import com.oracle.bmc.objectstorage.responses.ListMultipartUploadsResponse;
import com.oracle.bmc.objectstorage.responses.ListObjectVersionsResponse;
import com.oracle.bmc.objectstorage.responses.ListObjectsResponse;
import com.oracle.bmc.objectstorage.responses.ListPreauthenticatedRequestsResponse;
import com.oracle.bmc.objectstorage.responses.ListReplicationPoliciesResponse;
import com.oracle.bmc.objectstorage.responses.ListReplicationSourcesResponse;
import com.oracle.bmc.objectstorage.responses.ListRetentionRulesResponse;
import com.oracle.bmc.objectstorage.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.objectstorage.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.objectstorage.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class ObjectStoragePaginators {
    private final ObjectStorage client;

    public Iterable<ListBucketsResponse> listBucketsResponseIterator(final ListBucketsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListBucketsRequest.Builder>(){

            public ListBucketsRequest.Builder get() {
                return ListBucketsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListBucketsResponse, String>(){

            public String apply(ListBucketsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListBucketsRequest.Builder>, ListBucketsRequest>(){

            public ListBucketsRequest apply(RequestBuilderAndToken<ListBucketsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListBucketsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListBucketsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListBucketsRequest, ListBucketsResponse>(){

            public ListBucketsResponse apply(ListBucketsRequest request) {
                return ObjectStoragePaginators.this.client.listBuckets(request);
            }
        });
    }

    public Iterable<BucketSummary> listBucketsRecordIterator(final ListBucketsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListBucketsRequest.Builder>(){

            public ListBucketsRequest.Builder get() {
                return ListBucketsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListBucketsResponse, String>(){

            public String apply(ListBucketsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListBucketsRequest.Builder>, ListBucketsRequest>(){

            public ListBucketsRequest apply(RequestBuilderAndToken<ListBucketsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListBucketsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListBucketsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListBucketsRequest, ListBucketsResponse>(){

            public ListBucketsResponse apply(ListBucketsRequest request) {
                return ObjectStoragePaginators.this.client.listBuckets(request);
            }
        }, (Function)new Function<ListBucketsResponse, List<BucketSummary>>(){

            public List<BucketSummary> apply(ListBucketsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListMultipartUploadPartsResponse> listMultipartUploadPartsResponseIterator(final ListMultipartUploadPartsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListMultipartUploadPartsRequest.Builder>(){

            public ListMultipartUploadPartsRequest.Builder get() {
                return ListMultipartUploadPartsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMultipartUploadPartsResponse, String>(){

            public String apply(ListMultipartUploadPartsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMultipartUploadPartsRequest.Builder>, ListMultipartUploadPartsRequest>(){

            public ListMultipartUploadPartsRequest apply(RequestBuilderAndToken<ListMultipartUploadPartsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListMultipartUploadPartsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMultipartUploadPartsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListMultipartUploadPartsRequest, ListMultipartUploadPartsResponse>(){

            public ListMultipartUploadPartsResponse apply(ListMultipartUploadPartsRequest request) {
                return ObjectStoragePaginators.this.client.listMultipartUploadParts(request);
            }
        });
    }

    public Iterable<MultipartUploadPartSummary> listMultipartUploadPartsRecordIterator(final ListMultipartUploadPartsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListMultipartUploadPartsRequest.Builder>(){

            public ListMultipartUploadPartsRequest.Builder get() {
                return ListMultipartUploadPartsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMultipartUploadPartsResponse, String>(){

            public String apply(ListMultipartUploadPartsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMultipartUploadPartsRequest.Builder>, ListMultipartUploadPartsRequest>(){

            public ListMultipartUploadPartsRequest apply(RequestBuilderAndToken<ListMultipartUploadPartsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListMultipartUploadPartsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMultipartUploadPartsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListMultipartUploadPartsRequest, ListMultipartUploadPartsResponse>(){

            public ListMultipartUploadPartsResponse apply(ListMultipartUploadPartsRequest request) {
                return ObjectStoragePaginators.this.client.listMultipartUploadParts(request);
            }
        }, (Function)new Function<ListMultipartUploadPartsResponse, List<MultipartUploadPartSummary>>(){

            public List<MultipartUploadPartSummary> apply(ListMultipartUploadPartsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListMultipartUploadsResponse> listMultipartUploadsResponseIterator(final ListMultipartUploadsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListMultipartUploadsRequest.Builder>(){

            public ListMultipartUploadsRequest.Builder get() {
                return ListMultipartUploadsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMultipartUploadsResponse, String>(){

            public String apply(ListMultipartUploadsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMultipartUploadsRequest.Builder>, ListMultipartUploadsRequest>(){

            public ListMultipartUploadsRequest apply(RequestBuilderAndToken<ListMultipartUploadsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListMultipartUploadsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMultipartUploadsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListMultipartUploadsRequest, ListMultipartUploadsResponse>(){

            public ListMultipartUploadsResponse apply(ListMultipartUploadsRequest request) {
                return ObjectStoragePaginators.this.client.listMultipartUploads(request);
            }
        });
    }

    public Iterable<MultipartUpload> listMultipartUploadsRecordIterator(final ListMultipartUploadsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListMultipartUploadsRequest.Builder>(){

            public ListMultipartUploadsRequest.Builder get() {
                return ListMultipartUploadsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMultipartUploadsResponse, String>(){

            public String apply(ListMultipartUploadsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMultipartUploadsRequest.Builder>, ListMultipartUploadsRequest>(){

            public ListMultipartUploadsRequest apply(RequestBuilderAndToken<ListMultipartUploadsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListMultipartUploadsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMultipartUploadsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListMultipartUploadsRequest, ListMultipartUploadsResponse>(){

            public ListMultipartUploadsResponse apply(ListMultipartUploadsRequest request) {
                return ObjectStoragePaginators.this.client.listMultipartUploads(request);
            }
        }, (Function)new Function<ListMultipartUploadsResponse, List<MultipartUpload>>(){

            public List<MultipartUpload> apply(ListMultipartUploadsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListObjectVersionsResponse> listObjectVersionsResponseIterator(final ListObjectVersionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListObjectVersionsRequest.Builder>(){

            public ListObjectVersionsRequest.Builder get() {
                return ListObjectVersionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListObjectVersionsResponse, String>(){

            public String apply(ListObjectVersionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListObjectVersionsRequest.Builder>, ListObjectVersionsRequest>(){

            public ListObjectVersionsRequest apply(RequestBuilderAndToken<ListObjectVersionsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListObjectVersionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListObjectVersionsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListObjectVersionsRequest, ListObjectVersionsResponse>(){

            public ListObjectVersionsResponse apply(ListObjectVersionsRequest request) {
                return ObjectStoragePaginators.this.client.listObjectVersions(request);
            }
        });
    }

    public Iterable<ObjectVersionSummary> listObjectVersionsRecordIterator(final ListObjectVersionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListObjectVersionsRequest.Builder>(){

            public ListObjectVersionsRequest.Builder get() {
                return ListObjectVersionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListObjectVersionsResponse, String>(){

            public String apply(ListObjectVersionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListObjectVersionsRequest.Builder>, ListObjectVersionsRequest>(){

            public ListObjectVersionsRequest apply(RequestBuilderAndToken<ListObjectVersionsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListObjectVersionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListObjectVersionsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListObjectVersionsRequest, ListObjectVersionsResponse>(){

            public ListObjectVersionsResponse apply(ListObjectVersionsRequest request) {
                return ObjectStoragePaginators.this.client.listObjectVersions(request);
            }
        }, (Function)new Function<ListObjectVersionsResponse, List<ObjectVersionSummary>>(){

            public List<ObjectVersionSummary> apply(ListObjectVersionsResponse response) {
                return response.getObjectVersionCollection().getItems();
            }
        });
    }

    public Iterable<ListObjectsResponse> listObjectsResponseIterator(final ListObjectsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListObjectsRequest.Builder>(){

            public ListObjectsRequest.Builder get() {
                return ListObjectsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListObjectsResponse, String>(){

            public String apply(ListObjectsResponse response) {
                return response.getListObjects().getNextStartWith();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListObjectsRequest.Builder>, ListObjectsRequest>(){

            public ListObjectsRequest apply(RequestBuilderAndToken<ListObjectsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListObjectsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListObjectsRequest.Builder)input.getRequestBuilder()).start((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListObjectsRequest, ListObjectsResponse>(){

            public ListObjectsResponse apply(ListObjectsRequest request) {
                return ObjectStoragePaginators.this.client.listObjects(request);
            }
        });
    }

    public Iterable<ObjectSummary> listObjectsRecordIterator(final ListObjectsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListObjectsRequest.Builder>(){

            public ListObjectsRequest.Builder get() {
                return ListObjectsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListObjectsResponse, String>(){

            public String apply(ListObjectsResponse response) {
                return response.getListObjects().getNextStartWith();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListObjectsRequest.Builder>, ListObjectsRequest>(){

            public ListObjectsRequest apply(RequestBuilderAndToken<ListObjectsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListObjectsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListObjectsRequest.Builder)input.getRequestBuilder()).start((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListObjectsRequest, ListObjectsResponse>(){

            public ListObjectsResponse apply(ListObjectsRequest request) {
                return ObjectStoragePaginators.this.client.listObjects(request);
            }
        }, (Function)new Function<ListObjectsResponse, List<ObjectSummary>>(){

            public List<ObjectSummary> apply(ListObjectsResponse response) {
                return response.getListObjects().getObjects();
            }
        });
    }

    public Iterable<ListPreauthenticatedRequestsResponse> listPreauthenticatedRequestsResponseIterator(final ListPreauthenticatedRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListPreauthenticatedRequestsRequest.Builder>(){

            public ListPreauthenticatedRequestsRequest.Builder get() {
                return ListPreauthenticatedRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPreauthenticatedRequestsResponse, String>(){

            public String apply(ListPreauthenticatedRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPreauthenticatedRequestsRequest.Builder>, ListPreauthenticatedRequestsRequest>(){

            public ListPreauthenticatedRequestsRequest apply(RequestBuilderAndToken<ListPreauthenticatedRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListPreauthenticatedRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPreauthenticatedRequestsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListPreauthenticatedRequestsRequest, ListPreauthenticatedRequestsResponse>(){

            public ListPreauthenticatedRequestsResponse apply(ListPreauthenticatedRequestsRequest request) {
                return ObjectStoragePaginators.this.client.listPreauthenticatedRequests(request);
            }
        });
    }

    public Iterable<PreauthenticatedRequestSummary> listPreauthenticatedRequestsRecordIterator(final ListPreauthenticatedRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListPreauthenticatedRequestsRequest.Builder>(){

            public ListPreauthenticatedRequestsRequest.Builder get() {
                return ListPreauthenticatedRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPreauthenticatedRequestsResponse, String>(){

            public String apply(ListPreauthenticatedRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPreauthenticatedRequestsRequest.Builder>, ListPreauthenticatedRequestsRequest>(){

            public ListPreauthenticatedRequestsRequest apply(RequestBuilderAndToken<ListPreauthenticatedRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListPreauthenticatedRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPreauthenticatedRequestsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListPreauthenticatedRequestsRequest, ListPreauthenticatedRequestsResponse>(){

            public ListPreauthenticatedRequestsResponse apply(ListPreauthenticatedRequestsRequest request) {
                return ObjectStoragePaginators.this.client.listPreauthenticatedRequests(request);
            }
        }, (Function)new Function<ListPreauthenticatedRequestsResponse, List<PreauthenticatedRequestSummary>>(){

            public List<PreauthenticatedRequestSummary> apply(ListPreauthenticatedRequestsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListReplicationPoliciesResponse> listReplicationPoliciesResponseIterator(final ListReplicationPoliciesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListReplicationPoliciesRequest.Builder>(){

            public ListReplicationPoliciesRequest.Builder get() {
                return ListReplicationPoliciesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListReplicationPoliciesResponse, String>(){

            public String apply(ListReplicationPoliciesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListReplicationPoliciesRequest.Builder>, ListReplicationPoliciesRequest>(){

            public ListReplicationPoliciesRequest apply(RequestBuilderAndToken<ListReplicationPoliciesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListReplicationPoliciesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListReplicationPoliciesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListReplicationPoliciesRequest, ListReplicationPoliciesResponse>(){

            public ListReplicationPoliciesResponse apply(ListReplicationPoliciesRequest request) {
                return ObjectStoragePaginators.this.client.listReplicationPolicies(request);
            }
        });
    }

    public Iterable<ReplicationPolicySummary> listReplicationPoliciesRecordIterator(final ListReplicationPoliciesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListReplicationPoliciesRequest.Builder>(){

            public ListReplicationPoliciesRequest.Builder get() {
                return ListReplicationPoliciesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListReplicationPoliciesResponse, String>(){

            public String apply(ListReplicationPoliciesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListReplicationPoliciesRequest.Builder>, ListReplicationPoliciesRequest>(){

            public ListReplicationPoliciesRequest apply(RequestBuilderAndToken<ListReplicationPoliciesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListReplicationPoliciesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListReplicationPoliciesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListReplicationPoliciesRequest, ListReplicationPoliciesResponse>(){

            public ListReplicationPoliciesResponse apply(ListReplicationPoliciesRequest request) {
                return ObjectStoragePaginators.this.client.listReplicationPolicies(request);
            }
        }, (Function)new Function<ListReplicationPoliciesResponse, List<ReplicationPolicySummary>>(){

            public List<ReplicationPolicySummary> apply(ListReplicationPoliciesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListReplicationSourcesResponse> listReplicationSourcesResponseIterator(final ListReplicationSourcesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListReplicationSourcesRequest.Builder>(){

            public ListReplicationSourcesRequest.Builder get() {
                return ListReplicationSourcesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListReplicationSourcesResponse, String>(){

            public String apply(ListReplicationSourcesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListReplicationSourcesRequest.Builder>, ListReplicationSourcesRequest>(){

            public ListReplicationSourcesRequest apply(RequestBuilderAndToken<ListReplicationSourcesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListReplicationSourcesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListReplicationSourcesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListReplicationSourcesRequest, ListReplicationSourcesResponse>(){

            public ListReplicationSourcesResponse apply(ListReplicationSourcesRequest request) {
                return ObjectStoragePaginators.this.client.listReplicationSources(request);
            }
        });
    }

    public Iterable<ReplicationSource> listReplicationSourcesRecordIterator(final ListReplicationSourcesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListReplicationSourcesRequest.Builder>(){

            public ListReplicationSourcesRequest.Builder get() {
                return ListReplicationSourcesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListReplicationSourcesResponse, String>(){

            public String apply(ListReplicationSourcesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListReplicationSourcesRequest.Builder>, ListReplicationSourcesRequest>(){

            public ListReplicationSourcesRequest apply(RequestBuilderAndToken<ListReplicationSourcesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListReplicationSourcesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListReplicationSourcesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListReplicationSourcesRequest, ListReplicationSourcesResponse>(){

            public ListReplicationSourcesResponse apply(ListReplicationSourcesRequest request) {
                return ObjectStoragePaginators.this.client.listReplicationSources(request);
            }
        }, (Function)new Function<ListReplicationSourcesResponse, List<ReplicationSource>>(){

            public List<ReplicationSource> apply(ListReplicationSourcesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListRetentionRulesResponse> listRetentionRulesResponseIterator(final ListRetentionRulesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListRetentionRulesRequest.Builder>(){

            public ListRetentionRulesRequest.Builder get() {
                return ListRetentionRulesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRetentionRulesResponse, String>(){

            public String apply(ListRetentionRulesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRetentionRulesRequest.Builder>, ListRetentionRulesRequest>(){

            public ListRetentionRulesRequest apply(RequestBuilderAndToken<ListRetentionRulesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListRetentionRulesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRetentionRulesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListRetentionRulesRequest, ListRetentionRulesResponse>(){

            public ListRetentionRulesResponse apply(ListRetentionRulesRequest request) {
                return ObjectStoragePaginators.this.client.listRetentionRules(request);
            }
        });
    }

    public Iterable<RetentionRuleSummary> listRetentionRulesRecordIterator(final ListRetentionRulesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListRetentionRulesRequest.Builder>(){

            public ListRetentionRulesRequest.Builder get() {
                return ListRetentionRulesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRetentionRulesResponse, String>(){

            public String apply(ListRetentionRulesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRetentionRulesRequest.Builder>, ListRetentionRulesRequest>(){

            public ListRetentionRulesRequest apply(RequestBuilderAndToken<ListRetentionRulesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListRetentionRulesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRetentionRulesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListRetentionRulesRequest, ListRetentionRulesResponse>(){

            public ListRetentionRulesResponse apply(ListRetentionRulesRequest request) {
                return ObjectStoragePaginators.this.client.listRetentionRules(request);
            }
        }, (Function)new Function<ListRetentionRulesResponse, List<RetentionRuleSummary>>(){

            public List<RetentionRuleSummary> apply(ListRetentionRulesResponse response) {
                return response.getRetentionRuleCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return ObjectStoragePaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return ObjectStoragePaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return ObjectStoragePaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return ObjectStoragePaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return ObjectStoragePaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return ObjectStoragePaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public ObjectStoragePaginators(ObjectStorage client) {
        this.client = client;
    }
}

