/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.io.internal;

import com.oracle.bmc.io.internal.WrappedFileInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResettableFileInputStream
extends FilterInputStream {
    private static final Logger LOG = LoggerFactory.getLogger(ResettableFileInputStream.class);
    private final boolean alreadyWrapped;
    private final State state;

    public ResettableFileInputStream(FileInputStream fis) {
        super(fis);
        this.alreadyWrapped = ResettableFileInputStream.isAlreadyWrapped(fis);
        if (!this.alreadyWrapped && !ResettableFileInputStream.canBeWrapped(fis)) {
            throw new IllegalArgumentException("The provided FileInputStream cannot be wrapped because it does not provide a way to change position");
        }
        this.state = this.alreadyWrapped ? new AlreadyWrappedState() : new NeedsToBeWrappedState(fis.getChannel());
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.state.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.state.reset();
    }

    public static boolean canBeWrapped(FileInputStream fis) {
        try {
            fis.getChannel().position();
            return true;
        }
        catch (IOException e) {
            LOG.trace("FileInputStream cannot be wrapped, since its file channel does not provide a position");
            return false;
        }
    }

    public static boolean isAlreadyWrapped(FileInputStream fis) {
        return fis instanceof WrappedFileInputStream;
    }

    private final class NeedsToBeWrappedState
    implements State {
        private FileChannel fileChannel;
        private long markPosition = -1L;

        public NeedsToBeWrappedState(FileChannel fileChannel) {
            this.fileChannel = fileChannel;
        }

        @Override
        public synchronized void mark(int readlimit) {
            try {
                this.markPosition = this.fileChannel.position();
                LOG.trace("mark called, markPosition={}", (Object)this.markPosition);
            }
            catch (IOException ex) {
                this.markPosition = -1L;
            }
        }

        @Override
        public synchronized void reset() throws IOException {
            LOG.trace("reset called, markPosition={}", (Object)this.markPosition);
            if (this.markPosition < 0L) {
                throw new IOException("Resetting to invalid mark");
            }
            this.fileChannel.position(this.markPosition);
        }
    }

    private final class AlreadyWrappedState
    implements State {
        private AlreadyWrappedState() {
        }

        @Override
        public synchronized void mark(int readlimit) {
            ResettableFileInputStream.this.in.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            ResettableFileInputStream.this.in.reset();
        }
    }

    private static interface State {
        public void mark(int var1);

        public void reset() throws IOException;
    }
}

