/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.internal;

import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentLengthFilter
implements ClientRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ContentLengthFilter.class);
    private final boolean removeZeroLengthHeader;

    public ContentLengthFilter() {
        this(true);
    }

    public ContentLengthFilter(boolean removeZeroLengthHeader) {
        this.removeZeroLengthHeader = removeZeroLengthHeader;
    }

    public void filter(ClientRequestContext requestContext) {
        MultivaluedMap headers = requestContext.getHeaders();
        String method = requestContext.getMethod();
        String uri = requestContext.getUri().toString();
        if (headers == null) {
            LOG.debug("Headers from request context is null for Method [{}], URI [{}]", (Object)method, (Object)uri);
            return;
        }
        String contentLengthHeader = null;
        for (String key : headers.keySet()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)"Content-Length", (CharSequence)key)) continue;
            contentLengthHeader = key;
        }
        if (contentLengthHeader == null) {
            LOG.debug("content-length not found for Method [{}], URI [{}]", (Object)method, (Object)uri);
            return;
        }
        Object contentLengthValue = headers.getFirst(contentLengthHeader);
        if (!this.removeZeroLengthHeader && "0".equals(contentLengthValue)) {
            LOG.debug("Not removing zero content-length for Mehtod [{}], URI [{}]", (Object)method, (Object)uri);
            return;
        }
        Object existingContentLengthValue = headers.remove((Object)contentLengthHeader);
        if (existingContentLengthValue != null) {
            LOG.debug("Removed existing content-length header for Method [{}], URI [{}], Existing Value [{}]", new Object[]{method, uri, existingContentLengthValue});
        } else {
            LOG.debug("content-length not found for Method [{}], URI [{}]", (Object)method, (Object)uri);
        }
    }
}

