/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.mongo.operate;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.ReplaceOptions;
import org.apache.drill.metastore.mongo.exception.MongoMetastoreException;
import org.apache.drill.metastore.mongo.operate.MongoOperation;
import org.bson.Document;
import org.bson.conversions.Bson;

public class Overwrite
implements MongoOperation {
    private final Bson filter;
    private final Document data;

    public Overwrite(Document data, Bson filter) {
        this.data = data;
        this.filter = filter;
    }

    public Bson filter() {
        return this.filter;
    }

    public Document data() {
        return this.data;
    }

    @Override
    public void execute(MongoCollection<Document> collection) {
        ReplaceOptions replaceOptions = new ReplaceOptions().upsert(true);
        try {
            collection.replaceOne(this.filter, (Object)this.data, replaceOptions);
        }
        catch (Exception e) {
            throw new MongoMetastoreException(String.format("failed to overwrite document by %s into %s", this.filter.toString(), collection.getNamespace()), e);
        }
    }
}

