/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data.orc;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.orc.OrcValueReader;
import org.apache.iceberg.orc.OrcValueReaders;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.DateTimeUtil;
import org.apache.iceberg.util.UUIDUtil;
import org.apache.orc.storage.ql.exec.vector.BytesColumnVector;
import org.apache.orc.storage.ql.exec.vector.ColumnVector;
import org.apache.orc.storage.ql.exec.vector.DecimalColumnVector;
import org.apache.orc.storage.ql.exec.vector.ListColumnVector;
import org.apache.orc.storage.ql.exec.vector.LongColumnVector;
import org.apache.orc.storage.ql.exec.vector.MapColumnVector;
import org.apache.orc.storage.ql.exec.vector.TimestampColumnVector;

public class GenericOrcReaders {
    private GenericOrcReaders() {
    }

    public static OrcValueReader<Record> struct(List<OrcValueReader<?>> readers, Types.StructType struct, Map<Integer, ?> idToConstant) {
        return new StructReader(readers, struct, idToConstant);
    }

    public static OrcValueReader<List<?>> array(OrcValueReader<?> elementReader) {
        return new ListReader(elementReader);
    }

    public static OrcValueReader<Map<?, ?>> map(OrcValueReader<?> keyReader, OrcValueReader<?> valueReader) {
        return new MapReader(keyReader, valueReader);
    }

    public static OrcValueReader<OffsetDateTime> timestampTzs() {
        return TimestampTzReader.INSTANCE;
    }

    public static OrcValueReader<BigDecimal> decimals() {
        return DecimalReader.INSTANCE;
    }

    public static OrcValueReader<String> strings() {
        return StringReader.INSTANCE;
    }

    public static OrcValueReader<UUID> uuids() {
        return UUIDReader.INSTANCE;
    }

    public static OrcValueReader<ByteBuffer> bytes() {
        return BytesReader.INSTANCE;
    }

    public static OrcValueReader<LocalTime> times() {
        return TimeReader.INSTANCE;
    }

    public static OrcValueReader<LocalDate> dates() {
        return DateReader.INSTANCE;
    }

    public static OrcValueReader<LocalDateTime> timestamps() {
        return TimestampReader.INSTANCE;
    }

    private static class ListReader
    implements OrcValueReader<List<?>> {
        private final OrcValueReader<?> elementReader;

        private ListReader(OrcValueReader<?> elementReader) {
            this.elementReader = elementReader;
        }

        public List<?> nonNullRead(ColumnVector vector, int row) {
            ListColumnVector listVector = (ListColumnVector)vector;
            int offset = (int)listVector.offsets[row];
            int length = (int)listVector.lengths[row];
            ArrayList elements = Lists.newArrayListWithExpectedSize((int)length);
            for (int c = 0; c < length; ++c) {
                elements.add(this.elementReader.read(listVector.child, offset + c));
            }
            return elements;
        }

        public void setBatchContext(long batchOffsetInFile) {
            this.elementReader.setBatchContext(batchOffsetInFile);
        }
    }

    private static class MapReader
    implements OrcValueReader<Map<?, ?>> {
        private final OrcValueReader<?> keyReader;
        private final OrcValueReader<?> valueReader;

        private MapReader(OrcValueReader<?> keyReader, OrcValueReader<?> valueReader) {
            this.keyReader = keyReader;
            this.valueReader = valueReader;
        }

        public Map<?, ?> nonNullRead(ColumnVector vector, int row) {
            MapColumnVector mapVector = (MapColumnVector)vector;
            int offset = (int)mapVector.offsets[row];
            long length = mapVector.lengths[row];
            HashMap map = Maps.newHashMapWithExpectedSize((int)((int)length));
            int c = 0;
            while ((long)c < length) {
                map.put(this.keyReader.read(mapVector.keys, offset + c), this.valueReader.read(mapVector.values, offset + c));
                ++c;
            }
            return map;
        }

        public void setBatchContext(long batchOffsetInFile) {
            this.keyReader.setBatchContext(batchOffsetInFile);
            this.valueReader.setBatchContext(batchOffsetInFile);
        }
    }

    private static class StructReader
    extends OrcValueReaders.StructReader<Record> {
        private final Types.StructType structType;

        protected StructReader(List<OrcValueReader<?>> readers, Types.StructType structType, Map<Integer, ?> idToConstant) {
            super(readers, structType, idToConstant);
            this.structType = structType;
        }

        protected Record create() {
            return GenericRecord.create((Types.StructType)this.structType);
        }

        protected void set(Record struct, int pos, Object value) {
            struct.set(pos, value);
        }
    }

    private static class BytesReader
    implements OrcValueReader<ByteBuffer> {
        public static final OrcValueReader<ByteBuffer> INSTANCE = new BytesReader();

        private BytesReader() {
        }

        public ByteBuffer nonNullRead(ColumnVector vector, int row) {
            BytesColumnVector bytesVector = (BytesColumnVector)vector;
            return ByteBuffer.wrap(bytesVector.vector[row], bytesVector.start[row], bytesVector.length[row]);
        }
    }

    private static class UUIDReader
    implements OrcValueReader<UUID> {
        public static final OrcValueReader<UUID> INSTANCE = new UUIDReader();

        private UUIDReader() {
        }

        public UUID nonNullRead(ColumnVector vector, int row) {
            BytesColumnVector bytesVector = (BytesColumnVector)vector;
            ByteBuffer buf = ByteBuffer.wrap(bytesVector.vector[row], bytesVector.start[row], bytesVector.length[row]);
            return UUIDUtil.convert((ByteBuffer)buf);
        }
    }

    private static class StringReader
    implements OrcValueReader<String> {
        public static final OrcValueReader<String> INSTANCE = new StringReader();

        private StringReader() {
        }

        public String nonNullRead(ColumnVector vector, int row) {
            BytesColumnVector bytesVector = (BytesColumnVector)vector;
            return new String(bytesVector.vector[row], bytesVector.start[row], bytesVector.length[row], StandardCharsets.UTF_8);
        }
    }

    private static class DecimalReader
    implements OrcValueReader<BigDecimal> {
        public static final OrcValueReader<BigDecimal> INSTANCE = new DecimalReader();

        private DecimalReader() {
        }

        public BigDecimal nonNullRead(ColumnVector vector, int row) {
            DecimalColumnVector cv = (DecimalColumnVector)vector;
            return cv.vector[row].getHiveDecimal().bigDecimalValue().setScale(cv.scale);
        }
    }

    private static class TimestampReader
    implements OrcValueReader<LocalDateTime> {
        public static final OrcValueReader<LocalDateTime> INSTANCE = new TimestampReader();

        private TimestampReader() {
        }

        public LocalDateTime nonNullRead(ColumnVector vector, int row) {
            TimestampColumnVector tcv = (TimestampColumnVector)vector;
            return Instant.ofEpochSecond(Math.floorDiv(tcv.time[row], 1000L), tcv.nanos[row]).atOffset(ZoneOffset.UTC).toLocalDateTime();
        }
    }

    private static class DateReader
    implements OrcValueReader<LocalDate> {
        public static final OrcValueReader<LocalDate> INSTANCE = new DateReader();

        private DateReader() {
        }

        public LocalDate nonNullRead(ColumnVector vector, int row) {
            return DateTimeUtil.dateFromDays((int)((int)((LongColumnVector)vector).vector[row]));
        }
    }

    private static class TimeReader
    implements OrcValueReader<LocalTime> {
        public static final OrcValueReader<LocalTime> INSTANCE = new TimeReader();

        private TimeReader() {
        }

        public LocalTime nonNullRead(ColumnVector vector, int row) {
            return DateTimeUtil.timeFromMicros((long)((LongColumnVector)vector).vector[row]);
        }
    }

    private static class TimestampTzReader
    implements OrcValueReader<OffsetDateTime> {
        public static final OrcValueReader<OffsetDateTime> INSTANCE = new TimestampTzReader();

        private TimestampTzReader() {
        }

        public OffsetDateTime nonNullRead(ColumnVector vector, int row) {
            TimestampColumnVector tcv = (TimestampColumnVector)vector;
            return Instant.ofEpochSecond(Math.floorDiv(tcv.time[row], 1000L), tcv.nanos[row]).atOffset(ZoneOffset.UTC);
        }
    }
}

