/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive.client;

import com.google.common.cache.CacheLoader;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.drill.common.AutoCloseables;
import org.apache.drill.exec.store.hive.ColumnListsCache;
import org.apache.drill.exec.store.hive.HiveReadEntry;
import org.apache.drill.exec.store.hive.HiveTableWithColumnCache;
import org.apache.drill.exec.store.hive.HiveTableWrapper;
import org.apache.drill.exec.store.hive.HiveUtilities;
import org.apache.drill.exec.store.hive.client.DrillHiveMetaStoreClient;
import org.apache.drill.exec.store.hive.client.TableName;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TableEntryCacheLoader
extends CacheLoader<TableName, HiveReadEntry> {
    private static final Logger logger = LoggerFactory.getLogger(TableEntryCacheLoader.class);
    private final DrillHiveMetaStoreClient client;

    TableEntryCacheLoader(DrillHiveMetaStoreClient client) {
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HiveReadEntry load(TableName key) throws Exception {
        List<Partition> partitions;
        Table table;
        DrillHiveMetaStoreClient drillHiveMetaStoreClient = this.client;
        synchronized (drillHiveMetaStoreClient) {
            table = this.getTable(key);
            partitions = this.getPartitions(key);
        }
        HiveTableWithColumnCache hiveTable = new HiveTableWithColumnCache(table, new ColumnListsCache(table));
        List<HiveTableWrapper.HivePartitionWrapper> partitionWrappers = this.getPartitionWrappers(partitions, hiveTable);
        return new HiveReadEntry(new HiveTableWrapper(hiveTable), partitionWrappers);
    }

    private List<HiveTableWrapper.HivePartitionWrapper> getPartitionWrappers(List<Partition> partitions, HiveTableWithColumnCache hiveTable) {
        if (partitions.isEmpty()) {
            return null;
        }
        return partitions.stream().map(partition -> HiveUtilities.createPartitionWithSpecColumns(hiveTable, partition)).collect(Collectors.toList());
    }

    private List<Partition> getPartitions(TableName key) throws TException {
        List partitions;
        try {
            partitions = this.client.listPartitions(key.getDbName(), key.getTableName(), (short)-1);
        }
        catch (MetaException | NoSuchObjectException e) {
            throw e;
        }
        catch (TException e) {
            logger.warn("Failure while attempting to get hive partitions. Retries once. ", (Throwable)e);
            AutoCloseable[] autoCloseableArray = new AutoCloseable[1];
            autoCloseableArray[0] = () -> ((DrillHiveMetaStoreClient)this.client).close();
            AutoCloseables.closeSilently((AutoCloseable[])autoCloseableArray);
            this.client.reconnect();
            partitions = this.client.listPartitions(key.getDbName(), key.getTableName(), (short)-1);
        }
        return partitions;
    }

    private Table getTable(TableName key) throws TException {
        Table table;
        try {
            table = this.client.getTable(key.getDbName(), key.getTableName());
        }
        catch (MetaException | NoSuchObjectException e) {
            throw e;
        }
        catch (TException e) {
            logger.warn("Failure while attempting to get hive table. Retries once. ", (Throwable)e);
            AutoCloseable[] autoCloseableArray = new AutoCloseable[1];
            autoCloseableArray[0] = () -> ((DrillHiveMetaStoreClient)this.client).close();
            AutoCloseables.closeSilently((AutoCloseable[])autoCloseableArray);
            this.client.reconnect();
            table = this.client.getTable(key.getDbName(), key.getTableName());
        }
        if (table == null) {
            throw new UnknownTableException(String.format("Unable to find table '%s'.", key.getTableName()));
        }
        return table;
    }
}

