/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class ParquetTypeVisitor<T> {
    private final Deque<String> fieldNames = Lists.newLinkedList();

    public static <T> T visit(Type type, ParquetTypeVisitor<T> visitor) {
        if (type instanceof MessageType) {
            return visitor.message((MessageType)type, ParquetTypeVisitor.visitFields(type.asGroupType(), visitor));
        }
        if (type.isPrimitive()) {
            return visitor.primitive(type.asPrimitiveType());
        }
        GroupType group = type.asGroupType();
        OriginalType annotation = group.getOriginalType();
        if (annotation != null) {
            switch (annotation) {
                case LIST: {
                    return ParquetTypeVisitor.visitList(group, visitor);
                }
                case MAP: {
                    return ParquetTypeVisitor.visitMap(group, visitor);
                }
            }
        }
        return visitor.struct(group, ParquetTypeVisitor.visitFields(group, visitor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T visitList(GroupType list, ParquetTypeVisitor<T> visitor) {
        Preconditions.checkArgument((!list.isRepetition(Type.Repetition.REPEATED) ? 1 : 0) != 0, (String)"Invalid list: top-level group is repeated: %s", (Object)list);
        Preconditions.checkArgument((list.getFieldCount() == 1 ? 1 : 0) != 0, (String)"Invalid list: does not contain single repeated field: %s", (Object)list);
        GroupType repeatedElement = ((Type)list.getFields().get(0)).asGroupType();
        Preconditions.checkArgument((boolean)repeatedElement.isRepetition(Type.Repetition.REPEATED), (Object)"Invalid list: inner group is not repeated");
        Preconditions.checkArgument((repeatedElement.getFieldCount() <= 1 ? 1 : 0) != 0, (String)"Invalid list: repeated group is not a single field: %s", (Object)list);
        visitor.beforeRepeatedElement((Type)repeatedElement);
        try {
            T elementResult = null;
            if (repeatedElement.getFieldCount() > 0) {
                Type elementField = repeatedElement.getType(0);
                visitor.beforeElementField(elementField);
                try {
                    elementResult = ParquetTypeVisitor.visit(elementField, visitor);
                }
                finally {
                    visitor.afterElementField(elementField);
                }
            }
            T t = visitor.list(list, elementResult);
            return t;
        }
        finally {
            visitor.afterRepeatedElement((Type)repeatedElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T visitMap(GroupType map, ParquetTypeVisitor<T> visitor) {
        Preconditions.checkArgument((!map.isRepetition(Type.Repetition.REPEATED) ? 1 : 0) != 0, (String)"Invalid map: top-level group is repeated: %s", (Object)map);
        Preconditions.checkArgument((map.getFieldCount() == 1 ? 1 : 0) != 0, (String)"Invalid map: does not contain single repeated field: %s", (Object)map);
        GroupType repeatedKeyValue = map.getType(0).asGroupType();
        Preconditions.checkArgument((boolean)repeatedKeyValue.isRepetition(Type.Repetition.REPEATED), (Object)"Invalid map: inner group is not repeated");
        Preconditions.checkArgument((repeatedKeyValue.getFieldCount() <= 2 ? 1 : 0) != 0, (Object)"Invalid map: repeated group does not have 2 fields");
        visitor.beforeRepeatedKeyValue((Type)repeatedKeyValue);
        try {
            T keyResult = null;
            T valueResult = null;
            switch (repeatedKeyValue.getFieldCount()) {
                case 2: {
                    Type keyType = repeatedKeyValue.getType(0);
                    visitor.beforeKeyField(keyType);
                    try {
                        keyResult = ParquetTypeVisitor.visit(keyType, visitor);
                    }
                    finally {
                        visitor.afterKeyField(keyType);
                    }
                    Type valueType = repeatedKeyValue.getType(1);
                    visitor.beforeValueField(valueType);
                    try {
                        valueResult = ParquetTypeVisitor.visit(valueType, visitor);
                        break;
                    }
                    finally {
                        visitor.afterValueField(valueType);
                    }
                }
                case 1: {
                    Type keyOrValue = repeatedKeyValue.getType(0);
                    if (keyOrValue.getName().equalsIgnoreCase("key")) {
                        visitor.beforeKeyField(keyOrValue);
                        try {
                            keyResult = ParquetTypeVisitor.visit(keyOrValue, visitor);
                            break;
                        }
                        finally {
                            visitor.afterKeyField(keyOrValue);
                        }
                    }
                    visitor.beforeValueField(keyOrValue);
                    try {
                        valueResult = ParquetTypeVisitor.visit(keyOrValue, visitor);
                        break;
                    }
                    finally {
                        visitor.afterValueField(keyOrValue);
                    }
                }
            }
            T t = visitor.map(map, keyResult, valueResult);
            return t;
        }
        finally {
            visitor.afterRepeatedKeyValue((Type)repeatedKeyValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> List<T> visitFields(GroupType group, ParquetTypeVisitor<T> visitor) {
        ArrayList results = Lists.newArrayListWithExpectedSize((int)group.getFieldCount());
        for (Type field : group.getFields()) {
            visitor.beforeField(field);
            try {
                results.add(ParquetTypeVisitor.visit(field, visitor));
            }
            finally {
                visitor.afterField(field);
            }
        }
        return results;
    }

    public T message(MessageType message, List<T> fields) {
        return null;
    }

    public T struct(GroupType struct, List<T> fields) {
        return null;
    }

    public T list(GroupType array, T element) {
        return null;
    }

    public T map(GroupType map, T key, T value) {
        return null;
    }

    public T primitive(PrimitiveType primitive) {
        return null;
    }

    public void beforeField(Type type) {
        this.fieldNames.push(type.getName());
    }

    public void afterField(Type type) {
        this.fieldNames.pop();
    }

    public void beforeRepeatedElement(Type element) {
        this.beforeField(element);
    }

    public void afterRepeatedElement(Type element) {
        this.afterField(element);
    }

    public void beforeElementField(Type element) {
        this.beforeField(element);
    }

    public void afterElementField(Type element) {
        this.afterField(element);
    }

    public void beforeRepeatedKeyValue(Type keyValue) {
        this.beforeField(keyValue);
    }

    public void afterRepeatedKeyValue(Type keyValue) {
        this.afterField(keyValue);
    }

    public void beforeKeyField(Type key) {
        this.beforeField(key);
    }

    public void afterKeyField(Type key) {
        this.afterField(key);
    }

    public void beforeValueField(Type value) {
        this.beforeField(value);
    }

    public void afterValueField(Type value) {
        this.afterField(value);
    }

    protected String[] currentPath() {
        return Lists.newArrayList(this.fieldNames.descendingIterator()).toArray(new String[0]);
    }

    protected String[] path(String name) {
        ArrayList list = Lists.newArrayList(this.fieldNames.descendingIterator());
        list.add(name);
        return list.toArray(new String[0]);
    }
}

