/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.message;

import io.jhdf.Utils;
import io.jhdf.exceptions.UnsupportedHdfException;
import io.jhdf.object.message.Message;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class FilterPipelineMessage
extends Message {
    private static final int OPTIONAL = 0;
    private final List<FilterInfo> filters;

    public FilterPipelineMessage(ByteBuffer bb, BitSet messageFlags) {
        super(messageFlags);
        byte version = bb.get();
        if (version != 1 && version != 2) {
            throw new UnsupportedHdfException("Only filer pipeline version 1 or 2 are supported");
        }
        int numberOfFilters = bb.get();
        this.filters = new ArrayList<FilterInfo>(numberOfFilters);
        if (version == 1) {
            bb.position(bb.position() + 6);
        }
        for (int i = 0; i < numberOfFilters; ++i) {
            int filterId = Utils.readBytesAsUnsignedInt(bb, 2);
            int nameLength = version == 2 && filterId < 256 ? 0 : Utils.readBytesAsUnsignedInt(bb, 2);
            BitSet flags = BitSet.valueOf(new byte[]{bb.get(), bb.get()});
            boolean optional = flags.get(0);
            int numberOfDataValues = Utils.readBytesAsUnsignedInt(bb, 2);
            String name = nameLength >= 2 ? Utils.readUntilNull(Utils.createSubBuffer(bb, nameLength)) : "undefined";
            int[] data = new int[numberOfDataValues];
            for (int j = 0; j < numberOfDataValues; ++j) {
                data[j] = bb.getInt();
            }
            if (version == 1 && numberOfDataValues % 2 != 0) {
                bb.position(bb.position() + 4);
            }
            this.filters.add(new FilterInfo(filterId, name, optional, data));
        }
    }

    public List<FilterInfo> getFilters() {
        return this.filters;
    }

    public static class FilterInfo {
        private final int id;
        private final String name;
        private final boolean optional;
        private final int[] data;

        public FilterInfo(int id, String name, boolean optional, int[] data) {
            this.id = id;
            this.name = name;
            this.optional = optional;
            this.data = ArrayUtils.clone((int[])data);
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public int[] getData() {
            return ArrayUtils.clone((int[])this.data);
        }

        public String toString() {
            return "FilterInfo [id=" + this.id + ", name=" + this.name + ", optional=" + this.optional + ", data=" + Arrays.toString(this.data) + "]";
        }
    }
}

