/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.io;

import java.util.ArrayList;

public class CSVRecordParser {
    private static final int CH_QUOTE = 1;
    private static final int CH_WHITESPACE = 2;
    private static final int CH_DATA = 3;
    private static final int CH_SEPARATOR = 4;
    private static final int CH_EOL = 5;
    private static final int STATE_DATA = 1;
    private static final int STATE_BEFORE = 2;
    private static final int STATE_QUOTED_DATA = 3;
    private static final int STATE_SEEN_QUOTE = 4;
    private static final int STATE_AFTER = 5;
    private static final String[] strArrayType = new String[0];
    private char quote = (char)34;
    private char separator = (char)44;
    private int loc = 0;
    private boolean isStrictMode = false;

    public String[] parse(String record) {
        this.loc = 0;
        ArrayList<String> vals = new ArrayList<String>();
        int lineLen = record.length();
        while (this.loc < lineLen) {
            vals.add(this.parseField(record));
        }
        return vals.toArray(strArrayType);
    }

    private String parseField(String line) {
        StringBuffer data = new StringBuffer();
        int state = 2;
        while (true) {
            int category = 5;
            if (this.loc < line.length()) {
                category = this.categorize(line.charAt(this.loc));
            }
            block0 : switch (state) {
                case 2: {
                    switch (category) {
                        case 2: {
                            ++this.loc;
                            break block0;
                        }
                        case 1: {
                            ++this.loc;
                            state = 3;
                            break block0;
                        }
                        case 4: {
                            ++this.loc;
                            return "";
                        }
                        case 3: {
                            data.append(line.charAt(this.loc));
                            state = 1;
                            ++this.loc;
                            break block0;
                        }
                        case 5: {
                            return null;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (category) {
                        case 4: 
                        case 5: {
                            ++this.loc;
                            return data.toString();
                        }
                        case 1: {
                            if (this.isStrictMode) {
                                throw new IllegalArgumentException("Malformed field - quote not at beginning of field");
                            }
                            data.append(line.charAt(this.loc));
                            ++this.loc;
                            break block0;
                        }
                        case 2: 
                        case 3: {
                            data.append(line.charAt(this.loc));
                            ++this.loc;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (category) {
                        case 1: {
                            ++this.loc;
                            state = 4;
                            break block0;
                        }
                        case 2: 
                        case 3: 
                        case 4: {
                            data.append(line.charAt(this.loc));
                            ++this.loc;
                            break block0;
                        }
                        case 5: {
                            return data.toString();
                        }
                    }
                    break;
                }
                case 4: {
                    switch (category) {
                        case 1: {
                            ++this.loc;
                            data.append('\"');
                            state = 3;
                            break block0;
                        }
                        case 4: 
                        case 5: {
                            ++this.loc;
                            return data.toString();
                        }
                        case 2: {
                            ++this.loc;
                            state = 5;
                            break block0;
                        }
                        case 3: {
                            throw new IllegalArgumentException("Malformed field - quote not at end of field");
                        }
                    }
                    break;
                }
                case 5: {
                    switch (category) {
                        case 1: {
                            throw new IllegalArgumentException("Malformed field - unexpected quote");
                        }
                        case 4: 
                        case 5: {
                            ++this.loc;
                            return data.toString();
                        }
                        case 2: {
                            ++this.loc;
                            break block0;
                        }
                        case 3: {
                            throw new IllegalArgumentException("Malformed field - unexpected data after quote");
                        }
                    }
                }
            }
        }
    }

    private int categorize(char c) {
        switch (c) {
            case '\n': 
            case '\r': 
            case ' ': 
            case '\u00ff': {
                return 2;
            }
        }
        if (c == this.quote) {
            return 1;
        }
        if (c == this.separator) {
            return 4;
        }
        if ('!' <= c && c <= '~') {
            return 3;
        }
        if ('\u0000' <= c && c <= ' ') {
            return 2;
        }
        if (Character.isWhitespace(c)) {
            return 2;
        }
        return 3;
    }
}

