

package org.apache.drill.exec.expr.fn.impl.gcast;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;
import javax.inject.Inject;
import io.netty.buffer.DrillBuf;

/*
 * This class is generated using freemarker and the CastFunctionsSrcVarLen.java template.
 */
@SuppressWarnings("unused")
@FunctionTemplate(name = "castFLOAT4", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.NULL_IF_NULL)
public class CastVarCharFloat4 implements DrillSimpleFunc{

  @Param VarCharHolder in;
  @Output Float4Holder out;

  public void setup() {}

  public void eval() {
      
      byte[] buf = new byte[in.end - in.start];
      in.buffer.getBytes(in.start, buf, 0, in.end - in.start);
    
      //TODO: need capture format exception, and issue SQLERR code.
      out.value = Float.parseFloat(new String(buf, com.google.common.base.Charsets.UTF_8));
      
  }
}

 

